/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

var request = require('request'),
    cookieUtil = require('./cookie-util'),
    log4js = require('log4js'),
    logger = log4js.getLogger('audit-client'),
    path = require('path'),
    fs = require('fs'),
    url = require('url'),	
    uuid = require('node-uuid');	

exports.audit = (req, data, jsonObj) => {
  logger.debug('Audit is enabled:'+ process.env.AUDIT_ENABLED);
  if (process.env.AUDIT_ENABLED === 'true') {
    var creationTimestamp = new Date(Date.now());
    var expT = creationTimestamp.toISOString();
    var body;	
    if (req && (req.instance || req.body)) {	
      body = req.body;
    }	  
    else {
      body = '';	  
    }
    var path = req.originalUrl || req.path;
    var res, actions, severity, user, status, outcome, action, cont_id, map;
    if (process.env.CONTAINER_ID) cont_id = process.env.CONTAINER_ID.trim();
    var uuid1 = uuid.v1();	
    if (data && data.status) {
      status = data.status;
    } else {
      status = '';	  
    }	  
    if (data && data.user) {
      user = data.user;	  
    } else {
      user = '';
    }
    if (data && data.map) map = data.map;
    if (status >= 200 && status < 300) {
      severity = 'normal';
      outcome = 'success';	  
    } else if (status >= 400){
      severity = 'critical';
      outcome = 'failure';	  
    } else {
      outcome = 'unknown';
      severity = 'unknown';	  
    }
    if (data && data.action) {
      action = data.action;
    } else if (req.method === 'GET') {
      action = 'read';
    } else if (req.method === 'POST') {
      action = 'create';
    } else if (req.method === 'PUT') {
      action = 'update';
    } else if (req.method === 'DELETE') {
      action = 'delete';
    }
    //add body
    if ((action === 'create' || action === 'update') && path && path.indexOf('/acms/v1/services') >-1) {
      res = path.substring(path.lastIndexOf("/")+1, path.length)
      if (process.env.AUDIT_DETAIL === 'true') {
        actions = body
      }
    }
    // service-policy
    if ((action === 'read') && path && path.indexOf('/acms/v1/scopes')>-1) {
      res = path.substring(path.lastIndexOf("/")+1, path.length)
    }
    if ((action === 'create' || action ==='delete') && path && path.indexOf('/acms/v1/scopes')>-1) {
      if (process.env.AUDIT_DETAIL === 'true') {
        actions = body 
      }
      if (action === 'delete') {
	if (process.env.AUDIT_DETAIL === 'true') {
          actions = path.substring(path.lastIndexOf("/")+1, path.length);
        }
	res = path.substring(path.lastIndexOf("/", path.lastIndexOf("/",path.lastIndexOf("/")-1)-1)+1, path.lastIndexOf("/", path.lastIndexOf("/")-1))
      } else {
        res = path.substring(path.lastIndexOf("/", path.lastIndexOf("/")-1)+1, path.lastIndexOf("/"));
      }
      action = 'update';
    }
    var reg1 = /\/api\/v[0-9]+\/charts/,reg2 = /\/api\/v[0-9]+\/releases/,reg3 = /\/api\/v[0-9]+\/repos/,reg4 = /\/api\/v[0-9]+\/values/;
    var reg5 = /\/api\/v[0-9]+\/releasesCRNs/,reg6 = /\/api\/v[0-9]+\/history/,reg7 = /\/api\/v[0-9]+\/restoreDefaults/,reg8 = /\/api\/v[0-9]+\/synch/, reg9 = /\/api\/v[0-9]+\/categories/;
    // helm api
    if ((action === 'create' || action === 'update') && path && (path.match(reg2) || path.indexOf('/api/assets') > -1 || path.match(reg7) || path.match(reg4) || path.match(reg6) || path.match(reg1) || path.match(reg3) || path.match(reg5) || path.match(reg8) )) {
      res = body.name || body.chartId
      actions = body
    }
    //  helm api read delete
    if ((action === 'read' || action === 'delete') && path && (path.match(reg2) || path.indexOf('/api/assets') > -1 || path.match(reg7) || path.match(reg4) || path.match(reg6) || path.match(reg1) || path.match(reg3) || path.match(reg9) || path.match(reg5) || path.match(reg8) )) {
      if (path.indexOf('versions')>-1) {
        res = path.substring(path.lastIndexOf("/", path.indexOf("versions")-2)+1, path.lastIndexOf("versions")-1)
      } else if (path.indexOf('?') > -1) {
        res = path.substring(path.lastIndexOf("/", path.lastIndexOf("?")-1)+1, path.lastIndexOf("?"))
      } else {
	res = path.substring(path.lastIndexOf("/")+1, path.length)
      }
    }
    // CAM api
    if ((action === 'update' || action === 'create') && path && (path.indexOf('/api/v1/cloudconnections') > -1 || path.indexOf('/api/v1/stacks') > -1 || path.indexOf('/api/v1/serviceinstances') > -1 || path.indexOf('/api/v1/services') > -1)) {
      res = body.name
    }
    if ((action === 'read' || action === 'delete') && path && (path.indexOf('/api/v1/cloudconnections') > -1 || path.indexOf('/api/v1/stacks') > -1 || path.indexOf('/api/v1/serviceinstances') > -1 || path.indexOf('/api/v1/services') > -1)) {
      res = path.substring(path.lastIndexOf("/")+1, path.length)
    }
    // PAP
    if ((action === 'read' || action === 'delete') && path && path.indexOf('/acms/v1/services') > -1) {
      res = path.substring(path.lastIndexOf("/")+1, path.length)
    }
    // Team
    if (action === 'create' && path && (path.indexOf('/identity/api/v1/teams') >-1)) {
      res = body.name;
      if (process.env.AUDIT_DETAIL === 'true') {
        actions = body;
      }
    }                 
    if ((action === 'update' || action ==='create') && path && path.indexOf('/identity/api/v1/directory/ldap') >-1) {
      res = path.substring(path.lastIndexOf("/", path.lastIndexOf("/")-1)+1, path.lastIndexOf("/"))
      actions = body;                                                     
    }
    if ((action === 'delete' || action ==='read') && path && path.indexOf('/identity/api/v1/teams') >-1) {
      res = path.substring(path.lastIndexOf("/")+1, path.length)
    }                                                                        
    if (action === 'update' && path && path.indexOf('/identity/api/v1/teams') >-1) {
      if (process.env.AUDIT_DETAIL === 'true') {
        actions = body;
      }
      res = path.substring(path.lastIndexOf("/")+1, path.length);                                  
    }
    // team resource
    if ((action === 'delete') && path && path.indexOf('/identity/api/v1/teams/') > -1 && path.indexOf('/resources') > -1) {                                             
      res = path.substring(path.lastIndexOf("/", path.lastIndexOf("/")-1)+1, path.lastIndexOf("/"))
      if (process.env.AUDIT_ENABLED === 'true') {
        actions = body;                     
      }
    }                                                                                                                                                                   
     if ((action === 'create') && path && path.indexOf('/identity/api/v1/teams/') > -1 && path.indexOf('/resources') > -1) {
      res = path.substring(path.lastIndexOf("/", path.lastIndexOf("/")-1)+1, path.lastIndexOf("/"))
      if (process.env.AUDIT_ENABLED === 'true') {
        actions = body;
      }
      action = 'update'
    }
    //audit event
    let cadf = {
      "typeURI": "https://schemas.dmtf.org/cloud/audit/1.0/event",
      "eventType": "activity",
      "id": "icp:"+uuid1,
      "action": action,
      "requestPath": path,
      "initiator": {
	"typeURI": (user ? "service/security/account/user": ''),
        "name": user,
	"credential": {
	  "type":"token"
        },
	"host": {
          "user-agent": req.headers['user-agent'],
          "address": req.headers['host']		 
	}
      },
      "target": {
	"id": cont_id,      
	"name": res,
	"actions": actions,
        "typeURI": (map ? map: parseUrl(path)) // pretend this app is a service
      },
      "observer": {
        "id": "target"
      },
      "severity" : severity,
      "outcome": outcome,	    
      "reason": {
	"reasonType":"HTTP",
        "reasonCode": status, // like 200 or 400 TODO Change to a number when fixed in protobuf
      },
      "eventTime": expT,
      "kubernetes.container_id": cont_id, 
      "kubernetes.container_name": process.env.SERVICE_NAME, 
      "kubernetes.pod": process.env.POD_NAME || process.env.HOSTNAME,
      "kubernetes.namespace": process.env.POD_NAMESPACE, 
      "origination": identifyOrig(req.headers['referer'] || req.headers['user-agent']), 
      "version": "v1.0"
    };
    //checkPolicy(jsonObj, path, req.method, (resp)=>{
    //  if (resp === true) {
    writeAuditFile(cadf);	    
    //  } else {
    //    logger.debug('no policy rule exists');	    
    //  } 	  
    //});
  }
}

function identifyOrig(url) {
  var orig;
  if (url && url.indexOf('/console') >-1) {
    orig = 'ui';
  } else if (url && (url.indexOf('Mozilla') >-1 || url.indexOf('Firefox') >-1 || url.indexOf('Safari') >-1 || url.indexOf('Windows') >-1 || url.indexOf('Chrome') >-1)) {
    orig = 'ui'
  } else {
    orig = 'cli';
  }
  return orig;
}

function parseUrl(urlToParse) {
    var path;
    if (urlToParse) {
      var redirectParse = url.parse(urlToParse, true);
      if (redirectParse.pathname) {
        path = redirectParse.pathname;
	// mapping for security APIs
        if (path.indexOf('/identity/api/v1/teams') >-1 || path.indexOf('/identity/v1/api/usergroup')>-1) path = 'service/security/group'
        if (path.indexOf('/identity/api/v1/users')>-1) path = 'service/security/account/users'
	if (path.indexOf('/identity/api/v1/users/admin/getTeamResources')>-1) path='service/security/group/resource'
        if (path.indexOf('/identity/api/v1/teams') >-1 && path.indexOf('resources') >-1) path = 'service/security/group/resource'
        if (path.indexOf('/identity/api/v1/users/admin')>-1) path = 'service/security/account/admin'
        if (path.indexOf('/identity/api/v1/resource')>-1) path = 'service/security/node'
        if (path.indexOf('/identity/api/v1/certificates')>-1) path='service/security/key'
        if (path.indexOf('/v1/auth')>-1) path = 'service/security/credential'
	if (path.indexOf('/identity/api/v1/directory/ldap')>-1) path= 'service/storage/directory'
        if (path.indexOf('/identity/ap1/v1/account')>-1) path = 'service/security/account'
        if (path.indexOf('/identity/api/v1/service') >-1) path='service/security/identity'
	// mapping for helm APIs
	if (path.match(/\/api\/v[0-9]+\/repos/)) path = 'data/repos'
        if (path.match(/\/api\/v[0-9]+\/releases/)) path = 'data/releases'
	if (path.match(/\/api\/v[0-9]+\/categories/)) path = 'data/categories'
	if (path.match(/\/api\/v[0-9]+\/charts/) || path.indexOf('/charts')>-1) path ='data/charts'
        if (path.match(/\/api\/v[0-9]+\/releasesCRNs/)) path = 'data/releasesCRNs'
        if (path.indexOf('/api/assets')>-1) path = 'data/assets'
	if (path.match(/\/api\/v[0-9]+\/synch/)) path = 'data/sync'	
	if (path.match(/\/api\/v[0-9]+\/restoreDefaults/)) path = 'data/restoreDefaults'
	if (path.indexOf('/healthcheck') >-1) path = 'service/healthcheck'
	if (path.indexOf('/requiredAssets') >-1) path = 'data/assets'
	if (path.match(/\/api\/v[0-9]+\/values/)) path = 'data/values'
	if (path.match(/\/api\/v[0-9]+\/history/)) path = 'data/history'      
	// mapping for CAM APIs
	if (path.indexOf('/api/v1/stacks') >-1) path = 'data/stacks'
        if (path.indexOf('/api/v1/cloudconnections')>-1) path = 'data/cloudconnections'
	if (path.indexOf('/api/v1/serviceinstances')>-1) path ='data/serviceinstances'
        if (path.indexOf('/api/v1/service')>-1) path = 'data/service'
	// mapping for PAP service
	if (path.indexOf('/acms/v1/scopes')>-1 && path.indexOf('policies') >-1) path = 'security/policy'
	if (path.indexOf('/acms/v1/services') > -1) path = 'data/service'
      }
   }
   return path;	
}

function checkPolicy(jsonObject, resource, verb, cb) {
  //readFile((err,data) => {	  
  //var obj = JSON.parse(data);
  var obj = jsonObject;
  logger.debug('obj:'+JSON.stringify(jsonObject));
  for(var i = 0; i < obj.length; i++)
  { 
    logger.debug(obj[i].resources + ' ' +resource+' ' + verb+ ' '+ obj[i].verbs)
    var verbArr = obj[i].verbs.split(',');
    logger.debug('arr:'+verbArr)	  
    for (var j = 0; j < verbArr.length; j++) {	  
      if ((resource === obj[i].resources) && (verbArr[j] == verb)) {
        return cb(true);
      }	      
    }
  }	  
  return cb(false);	  
  //});	  
}
 
function readFile(cb) {
  var policy = path.join(__dirname, '..', 'policy.json');	
  require('fs').readFile(policy, 'utf8', function (err, data) {
  if (err) 
    return cb(err,null)	  
  return cb(null, data)	
  });
}

function writeAuditFile(data) {
  var filename
  if (process.env.AUDIT_LOG_PATH) {
    filename = process.env.AUDIT_LOG_PATH;
  } else {
    filename = '/var/log/audit/'+process.env.SERVICE_NAME+'-audit.log';
  }
  if (!process.env.audit) {
    logger.warn('No audit file found at path '+ filename + ', a new file will be created.');
    process.env.audit = 1;	  
  }
  var content = JSON.stringify(data)+ '\n';
  	
  fs.appendFile(filename, content, function (err) {
    if (err)
      logger.info('Unable to write to audit log.');
  });
  fs.stat(filename, function(err, stats) {
    if (stats && !((stats["mode"] &20)=== 20)) {      
        fs.chmod(filename, 0o664, function(err){if(err) logger.error('Unable to change filemode')});
    }
  });
}
