var provider = {
	countries: [
		'Afghanistan', 'Albanien', 'Algeriet', 'Andorra', 'Angola',
		'Antigua og Barbuda', 'Argentina', 'Armenien', 'Australien',
		'Azerbajdzjan', 'Azerbajdzjan', 'Bahamas', 'Bahrain', 'Bangladesh',
		'Barbados', 'Belgien', 'Belize', 'Benin', 'Bhutan', 'Bolivia',
		'Bosnien og Hercegovina', 'Botswana', 'Brasilien', 'Brunei',
		'Bulgarien', 'Burkina Faso', 'Burma (Myanmar)', 'Burundi',
		'Cypern', 'Danmark', 'Demokratiske Republik Kongo', 'Djibouti',
		'Den Centralafrikanske republik', 'Chile', 'Colombia', 'Costa Rica',
		'Dominica', 'Dominikanske republik', 'Ecuador', 'Egypten',
		'Ekvatorialguinea', 'El Salvador', 'Elfenbenskysten', 'Eritrea',
		'Estland', 'Etiopien', 'Fiji', 'Filippinerna', 'Finland', 'Frankrig',
		'Forenede Arabiske Emirater', 'Forenede Stater, USA', 'Gabon', 'Gambia',
		'Georgien', 'Georgien', 'Ghana', 'Grækenland', 'Grenada', 'Guatemala',
		'Guinea-Bissau', 'Guinea', 'Guyana', 'Haiti', 'Honduras', 'Indien',
		'Indonesien', 'Indonesien', 'Irak', 'Iran', 'Irland', 'Island',
		'Israel', 'Italien', 'Jamaica', 'Japan', 'Jemen', 'Jordan',
		'Kambodja', 'Kanada', 'Kap Verde', 'Kazakstan', 'Kazakstan',
		'Kenya', 'Kina', 'Kirgizistan', 'Kiribati', 'Komorerna', 'Kosovo',
		'Kroatien', 'Kuba', 'Kuwait', 'Laos', 'Lesotho', 'Letland', 'Libanon',
		'Liberia', 'Libyen', 'Liechtenstein', 'Litauen', 'Luxemburg',
		'Madagaskar', 'Makedonien', 'Malawi', 'Malaysia', 'Maldiverna', 'Mali',
		'Malta', 'Marocko', 'Marshalløerne', 'Mauretanien', 'Mauritius',
		'Mexiko', 'Moçambique', 'Moldavien', 'Monaco', 'Mongoliet', 'Montenegro',
		'Namibia', 'Nauru', 'Holland', 'Nepal', 'Nicaragua', 'Niger', 'Nigeria', 'Nordkorea',
		'Norge', 'New Zeeland', 'Oman', 'Pakistan', 'Palau', 'Panama', 'Panama',
		'Papua Nya Guinea', 'Paraguay', 'Peru', 'Polen', 'Portugal', 'Qatar',
		'Republikken Kongo', 'Rumænien', 'Rwanda', 'Rusland',
		'Saint Lucia', 'Salomonøerne', 'Samoa', 'San Marino',
		'Saudiarabien', 'Schweiz', 'Senegal', 'Serbien', 'Seychellerna', 'Sierra Leone',
		'Singapore', 'Slovakiet', 'Slovenien', 'Somalia', 'Spanien', 'Sri Lanka', 
		'Storbritannien', 'Sudan', 'Surinam', 'Sverige', 'Swaziland', 'Sydafrika', 'Sydkorea',
		'Syrien', 'Tadzjikistan', 'Taiwan', 'Tanzania', 'Tchad', 'Thailand',
		'Tjekkiet', 'Togo', 'Tonga', 'Trinidad og Tobago', 'Tunesien',
		'Tyrkiet', 'Tuvalu', 'Tyskland', 'Uganda', 'Ukraine', 'Ungarn', 'Uruguay', 
		'Uzbekistan', 'Vanuatu', 'Vatikanstaten', 'Venezuela', 'Vietnam', 'Hviderusland',
		'Zambia', 'Zimbabwe', 'Østrig', 'Østtimor',
	],

	real_cities: [
		'Allinge',
		'Allingåbro',
		'Almind',
		'Anholt',
		'Ans by',
		'Ansager',
		'Arden',
		'Askeby',
		'Asnæs',
		'Asperup',
		'Assens',
		'Asaa',
		'Augustenborg',
		'Aulum',
		'Auning',
		'Bagenkop',
		'Bagsværd',
		'Balle',
		'Ballerup',
		'Bandholm',
		'Barrit',
		'Beder',
		'Bedsted Thy',
		'Bevtoft',
		'Billum',
		'Billund',
		'Bindslev',
		'Birkerød',
		'Bjerringbro',
		'Bjert',
		'Bjæverskov',
		'Blokhus',
		'Blommenslyst',
		'Blåvand',
		'Boeslunde',
		'Bogense',
		'Bogø By',
		'Bolderslev',
		'Bording',
		'Borre',
		'Borup',
		'Brabrand',
		'Bramming',
		'Brande',
		'Branderup',
		'Bredebro',
		'Bredsten',
		'Brenderup',
		'Broager',
		'Broby',
		'Brovst',
		'Bryrup',
		'Brædstrup',
		'Brøndby',
		'Brøndby Strand',
		'Brønderslev',
		'Brønshøj',
		'Brørup',
		'Bylderup-Bov',
		'Bække',
		'Bækmarksbro',
		'Bælum',
		'Børkop',
		'Bøvlingbjerg',
		'Charlottenlund',
		'Christiansfeld',
		'Dalby',
		'Dalmose',
		'Dannemare',
		'Daugård',
		'Dianalund',
		'Dragør',
		'Dronninglund',
		'Dronningmølle',
		'Dybvad',
		'Ebberup',
		'Ebeltoft',
		'Egernsund',
		'Egtved',
		'Egå',
		'Ejby',
		'Ejstrupholm',
		'Engesvang',
		'Errindlev',
		'Erslev',
		'Esbjerg',
		'Eskebjerg',
		'Eskilstrup',
		'Espergærde',
		'Fakse',
		'Fakse Ladeplads',
		'Fanø',
		'Farsø',
		'Farum',
		'Fejø',
		'Ferritslev Fyn',
		'Fjenneslev',
		'Fjerritslev',
		'Flemming',
		'Fredensborg',
		'Fredericia',
		'Frederiksberg',
		'Frederikshavn',
		'Frederikssund',
		'Frederiksværk',
		'Frørup',
		'Frøstrup',
		'Fuglebjerg',
		'Fur',
		'Føllenslev',
		'Føvling',
		'Faaborg',
		'Fårevejle',
		'Fårup',
		'Fårvang',
		'Gadbjerg',
		'Gadstrup',
		'Galten',
		'Gandrup',
		'Gedser',
		'Gedsted',
		'Gedved',
		'Gelsted',
		'Gentofte',
		'Gesten',
		'Gilleleje',
		'Gislev',
		'Gislinge',
		'Gistrup',
		'Give',
		'Gjerlev',
		'Gjern',
		'Glamsbjerg',
		'Glejbjerg',
		'Glesborg',
		'Glostrup',
		'Glumsø',
		'Gram',
		'Gredstedbro',
		'Grenaa',
		'Greve',
		'Greve Strand',
		'Grevinge',
		'Grindsted',
		'Græsted',
		'Gråsten',
		'Gudbjerg',
		'Gudhjem',
		'Gudme',
		'Guldborg',
		'Gørding',
		'Gørlev',
		'Gørløse',
		'Haderslev',
		'Haderup',
		'Hadsten',
		'Hadsund',
		'Hagersten',
		'Hals',
		'Hammel',
		'Hampen',
		'Hanstholm',
		'Harboøre',
		'Harlev',
		'Harndrup',
		'Harpelunde',
		'Hasle',
		'Haslev',
		'Hasselager',
		'Havdrup',
		'Havndal',
		'Hedehusene',
		'Hedensted',
		'Hejls',
		'Hejnsvig',
		'Hellebæk',
		'Hellerup',
		'Helsinge',
		'Helsingør',
		'Hemmet',
		'Henne',
		'Herfølge',
		'Herlev',
		'Herlufmagle',
		'Herning',
		'Hesselager',
		'Hillerød',
		'Hinnerup',
		'Hirtshals',
		'Hjallerup',
		'Hjerm',
		'Hjortshøj',
		'Hjørring',
		'Hobro',
		'Holbæk',
		'Holeby',
		'Holme-Olstrup',
		'Holstebro',
		'Holsted',
		'Holte',
		'Horbelev',
		'Hornbæk',
		'Hornslet',
		'Hornsyld',
		'Horsens',
		'Horslunde',
		'Hovborg',
		'Hovedgård',
		'Humble',
		'Humlebæk',
		'Hundested',
		'Hundslund',
		'Hurup Thy',
		'Hvalsø',
		'Hvide Sande',
		'Hvidovre',
		'Højbjerg',
		'Højby',
		'Højer',
		'Højslev',
		'Høng',
		'Hørning',
		'Hørsholm',
		'Hørve',
		'Haarby',
		'Hårlev',
		'Idestrup',
		'Ikast',
		'Ishøj',
		'Janderup',
		'Jelling',
		'Jerslev',
		'Jerslev',
		'Jerup',
		'Jordrup',
		'Juelsminde',
		'Jyderup',
		'Jyllinge',
		'Jystrup',
		'Jægerspris',
		'Kalundborg',
		'Kalvehave',
		'Karby',
		'Karise',
		'Karlslunde',
		'Karrebæksminde',
		'Karup',
		'Kastrup',
		'Kerteminde',
		'Kettinge',
		'Kibæk',
		'Kirke Eskilstrup',
		'Kirke Hyllinge',
		'Kirke Såby',
		'Kjellerup',
		'Klampenborg',
		'Klarup',
		'Klemensker',
		'Klippinge',
		'Klovborg',
		'Knebel',
		'Kokkedal',
		'Kolding',
		'Kolind',
		'Kongens Lyngby',
		'Kongerslev',
		'Korsør',
		'Kruså',
		'Kvistgård',
		'Kværndrup',
		'København',
		'Køge',
		'Langebæk',
		'Langeskov',
		'Langå',
		'Lejre',
		'Lem',
		'Lemming',
		'Lemvig',
		'Lille Skensved',
		'Lintrup',
		'Liseleje',
		'Lundby',
		'Lunderskov',
		'Lynge',
		'Lystrup',
		'Læsø',
		'Løgstrup',
		'Løgstør',
		'Løgumkloster',
		'Løkken',
		'Løsning',
		'Låsby',
		'Malling',
		'Mariager',
		'Maribo',
		'Marslev',
		'Marstal',
		'Martofte',
		'Melby',
		'Mern',
		'Mesinge',
		'Middelfart',
		'Millinge',
		'Morud',
		'Munke Bjergby',
		'Munkebo',
		'Møldrup',
		'Mørke',
		'Mørkøv',
		'Måløv',
		'Mårslet',
		'Nakskov',
		'Nexø',
		'Nibe',
		'Nimtofte',
		'Nivå',
		'Nordborg',
		'Nyborg',
		'Nykøbing F',
		'Nykøbing M',
		'Nykøbing Sj',
		'Nyrup',
		'Nysted',
		'Nærum',
		'Næstved',
		'Nørager',
		'Nørre Alslev',
		'Nørre Asmindrup',
		'Nørre Nebel',
		'Nørre Snede',
		'Nørre Aaby',
		'Nørreballe',
		'Nørresundby',
		'Odder',
		'Odense',
		'Oksbøl',
		'Otterup',
		'Oure',
		'Outrup',
		'Padborg',
		'Pandrup',
		'Præstø',
		'Randbøl',
		'Randers',
		'Ranum',
		'Rask Mølle',
		'Redsted',
		'Regstrup',
		'Ribe',
		'Ringe',
		'Ringkøbing',
		'Ringsted',
		'Risskov',
		'Roskilde',
		'Roslev',
		'Rude',
		'Rudkøbing',
		'Ruds Vedby',
		'Rungsted Kyst',
		'Ry',
		'Rynkeby',
		'Ryomgård',
		'Ryslinge',
		'Rødby',
		'Rødding',
		'Rødekro',
		'Rødkærsbro',
		'Rødovre',
		'Rødvig Stevns',
		'Rømø',
		'Rønde',
		'Rønne',
		'Rønnede',
		'Rørvig',
		'Sabro',
		'Sakskøbing',
		'Saltum',
		'Samsø',
		'Sandved',
		'Sejerø',
		'Silkeborg',
		'Sindal',
		'Sjællands Odde',
		'Sjølund',
		'Skagen',
		'Skals',
		'Skamby',
		'Skanderborg',
		'Skibby',
		'Skive',
		'Skjern',
		'Skodsborg',
		'Skovlunde',
		'Skælskør',
		'Skærbæk',
		'Skævinge',
		'Skødstrup',
		'Skørping',
		'Skårup',
		'Slagelse',
		'Slangerup',
		'Smørum',
		'Snedsted',
		'Snekkersten',
		'Snertinge',
		'Solbjerg',
		'Solrød Strand',
		'Sommersted',
		'Sorring',
		'Sorø',
		'Spenstrup',
		'Spjald',
		'Sporup',
		'Spøttrup',
		'Stakroge',
		'Stege',
		'Stenderup',
		'Stenlille',
		'Stenløse',
		'Stenstrup',
		'Stensved',
		'Stoholm',
		'Stokkemarke',
		'Store Fuglede',
		'Store Heddinge',
		'Store Merløse',
		'Storvorde',
		'Stouby',
		'Strandby',
		'Struer',
		'Strøby',
		'Stubbekøbing',
		'Støvring',
		'Suldrup',
		'Sulsted',
		'Sunds',
		'Svaneke',
		'Svebølle',
		'Svendborg',
		'Svenstrup',
		'Svinninge',
		'Sydals',
		'Sæby',
		'Søborg',
		'Søby Ærø',
		'Søllested',
		'Sønder Felding',
		'Sønder Omme',
		'Sønder Stenderup',
		'Sønderborg',
		'Søndersø',
		'Sørvad',
		'Tappernøje',
		'Tarm',
		'Terndrup',
		'Them',
		'Thisted',
		'Thorsø',
		'Thyborøn',
		'Thyholm',
		'Tikøb',
		'Tilst',
		'Tim',
		'Tinglev',
		'Tistrup',
		'Tisvildeleje',
		'Tjele',
		'Tjæreborg',
		'Toftlund',
		'Tommerup',
		'Toreby',
		'Torrig',
		'Tranbjerg J',
		'Tranekær',
		'Trige',
		'Trustrup',
		'Tureby',
		'Tylstrup',
		'Tølløse',
		'Tønder',
		'Tørring',
		'Tårs',
		'Taastrup',
		'Ugerløse',
		'Uldum',
		'Ulfborg',
		'Ullerslev',
		'Ulstrup',
		'Vadum',
		'Valby',
		'Vallensbæk',
		'Vallensbæk Strand',
		'Vamdrup',
		'Vandel',
		'Vanløse',
		'Varde',
		'Vedbæk',
		'Veflinge',
		'Vejby',
		'Vejen',
		'Vejers Strand',
		'Vejle',
		'Vejle Øst',
		'Vejstrup',
		'Veksø Sjælland',
		'Vemb',
		'Vemmelev',
		'Vesløs',
		'Vestbjerg',
		'Vester Skerninge',
		'Vesterborg',
		'Vestervig',
		'Viborg',
		'Viby J',
		'Viby Sjælland',
		'Videbæk',
		'Vig',
		'Vildbjerg',
		'Vils',
		'Vinderup',
		'Vipperød',
		'Virum',
		'Vissenbjerg',
		'Viuf',
		'Vodskov',
		'Vojens',
		'Vonge',
		'Vorbasse',
		'Vordingborg',
		'Vrå',
		'Væggerløse',
		'Værløse',
		'Ærøskøbing',
		'Ølgod',
		'Ølsted',
		'Ølstykke',
		'Ørbæk',
		'Ørnhøj',
		'Ørsted',
		'Ørum Djurs',
		'Østbirk',
		'Øster Assels',
		'Øster Ulslev',
		'Øster Vrå',
		'Østermarie',
		'Aabenraa',
		'Aabybro',
		'Åbyhøj',
		'Aakirkeby',
		'Aalborg',
		'Ålbæk',
		'Aalestrup',
		'Ålsgårde',
		'Århus',
		'Årre',
		'Aars',
		'Årslev',
		'Aarup',
	],

	city_suffixes: [
		'holm', 'borg', 'bro', 'sted', 'sund', 'løse', 'berg', 'skov', 'slev'
	],

	street_prefixes: [
		'Hoved', 'Tvær', 'Store', 'Lille',
	],

	street_suffixes: [
		'vej', 'gade', ' Allé',
	],

	zip_formats: ['####'],

	building_number_formats: [
		'#', '##', '###', '####',
		'#A', '#B', '#C', '#D', '#E', '#F',
		'##A', '##B', '##C', '##D', '##E', '##F',
	],

	city_formats: [
		'{{real_city}}',
	],

	street_formats: [
		'{{street_prefix}}{{street_suffix}}',
		'{{first_name}}{{street_suffix}}',
		'{{last_name}}{{street_suffix}}',
	],

	address1_formats: [
		'{{street}} {{building_number}}',
		'{{street}} {{building_number}} {{address2}}',
	],

	address2_formats: ['Lgh ####'],

	address_formats: [
		'{{address1}}\n{{zip}} {{city}}',
	],

	city_suffix: function() {
		return this.random_element(this.city_suffixes);
	},

	real_city: function() {
		return this.random_element(this.real_cities);
	},

	street_prefix: function() {
		return this.random_element(this.street_prefixes);
	},

	street_suffix: function() {
		return this.random_element(this.street_suffixes);
	},

	street: function() {
		return this.populate_one_of(this.street_formats);
	},

	county: function() {
		return this.random_element(this.counties);
	},
};

module.exports = provider;
