let getIngressContext = function (req) {
  const env = process.env;
  let {headers = {}} = req;

  let xForwardedHost = headers['x-forwarded-host'];
  let xForwardedPort = headers['x-forwarded-port'];
  let xForwardedProto = headers['x-forwarded-proto'];
  let proxySubstitutePath = env.UI_INGRESS_PATH;

  let isIngress = !!xForwardedHost && !!xForwardedPort && !!xForwardedProto && !!proxySubstitutePath;

  return {env, xForwardedHost, xForwardedPort, xForwardedProto, proxySubstitutePath, isIngress};
};

module.exports = {
  getIngressContext
};
