/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

var request = require('request'),
    log4js = require('log4js'),
    logger = log4js.getLogger('token-client')

exports.token = (req, cb) => {
  var redirectUrl, tokenUrl
  if (process.env.NODE_ENV === 'development') {
    redirectUrl = process.env.WLP_REDIRECT_URL
  } else if (process.env.ICP_CALLBACK_URL) {
    redirectUrl = process.env.ICP_CALLBACK_URL
  } else {
    redirectUrl = 'https://'+process.env.ICP_PROXY_IP+':'+process.env.ICP_PROXY_PORT+'/auth/liberty/callback';
  }
  if (process.env.PLATFORM_AUTH_SERVICE_URL) {
    tokenUrl = process.env.PLATFORM_AUTH_SERVICE_URL;
  } else {
    tokenUrl = "https://"+process.env.ICP_MASTER_IP+":"+process.env.ICP_DEFAULT_PORT+"/idauth/oidc/endpoint/OP/token";
  }
  logger.debug('redirectUrl:'+redirectUrl)
  var reqBody = {
    'client_id': process.env.CLIENT_ID,
    'client_secret': process.env.CLIENT_SECRET,
    'code' : req.query.code,
    'redirect_uri' : redirectUrl,
    'grant_type' : 'authorization_code',
    'scope' : 'openid email profile'
  }

  var options = {
    method: 'POST',
    url: tokenUrl,
    form: reqBody,
    json: true,
    strictSSL: false,
    timeout: 60 * 1000,
    maxAttempts: 2
  }

  request(options,(err, res) => {
    if (err) {
      return cb(err, null)
    }
    cb(err, res)
  })
}
