import { RouteHandlerObject, RouteHandlerCallbackOptions, WorkboxPlugin } from 'workbox-core/types.js';
import './_version.js';
interface CacheOnlyOptions {
    cacheName?: string;
    plugins?: WorkboxPlugin[];
    matchOptions?: CacheQueryOptions;
}
/**
 * An implementation of a
 * [cache-only]{@link https://developers.google.com/web/fundamentals/instant-and-offline/offline-cookbook/#cache-only}
 * request strategy.
 *
 * This class is useful if you want to take advantage of any
 * [Workbox plugins]{@link https://developers.google.com/web/tools/workbox/guides/using-plugins}.
 *
 * If there is no cache match, this will throw a `WorkboxError` exception.
 *
 * @memberof module:workbox-strategies
 */
declare class CacheOnly implements RouteHandlerObject {
    private readonly _cacheName;
    private readonly _plugins;
    private readonly _matchOptions?;
    /**
     * @param {Object} options
     * @param {string} options.cacheName Cache name to store and retrieve
     * requests. Defaults to cache names provided by
     * [workbox-core]{@link module:workbox-core.cacheNames}.
     * @param {Array<Object>} options.plugins [Plugins]{@link https://developers.google.com/web/tools/workbox/guides/using-plugins}
     * to use in conjunction with this caching strategy.
     * @param {Object} options.matchOptions [`CacheQueryOptions`](https://w3c.github.io/ServiceWorker/#dictdef-cachequeryoptions)
     */
    constructor(options?: CacheOnlyOptions);
    /**
     * This method will perform a request strategy and follows an API that
     * will work with the
     * [Workbox Router]{@link module:workbox-routing.Router}.
     *
     * @param {Object} options
     * @param {Request|string} options.request A request to run this strategy for.
     * @param {Event} [options.event] The event that triggered the request.
     * @return {Promise<Response>}
     */
    handle({ event, request }: RouteHandlerCallbackOptions): Promise<Response>;
}
export { CacheOnly };
