"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _Text = require("@patternfly/react-core/dist/js/components/Text/Text.js");

var _propTypes = _interopRequireDefault(require("prop-types"));

var RiskDescription = function RiskDescription(_ref) {
  var riskValue = _ref.riskValue,
      riskMeta = _ref.riskMeta,
      showDescription = _ref.showDescription;
  // riskValue ranges from 1 to ∞
  var _riskMeta = riskMeta[riskValue - 1],
      IconComponent = _riskMeta.IconComponent,
      description = _riskMeta.description;
  return /*#__PURE__*/_react["default"].createElement("div", {
    className: "ins-c-rule__risk-description"
  }, /*#__PURE__*/_react["default"].createElement(IconComponent, {
    value: riskValue
  }), showDescription && /*#__PURE__*/_react["default"].createElement(_Text.Text, {
    className: "ins-c-rule__risk-detail-description-text",
    component: _Text.TextVariants.small
  }, description));
};

RiskDescription.propTypes = {
  riskValue: _propTypes["default"].number,
  riskMeta: _propTypes["default"].array,
  showDescription: _propTypes["default"].bool
};
var _default = RiskDescription;
exports["default"] = _default;