import React from 'react';
import PropTypes from 'prop-types';
import { Grid } from "@patternfly/react-core/dist/esm/layouts/Grid/Grid.js";
import { GridItem } from "@patternfly/react-core/dist/esm/layouts/Grid/GridItem.js";
import { Stack } from "@patternfly/react-core/dist/esm/layouts/Stack/Stack.js";
import { StackItem } from "@patternfly/react-core/dist/esm/layouts/Stack/StackItem.js";
import { Title } from "@patternfly/react-core/dist/esm/components/Title/Title.js";
import { Text } from "@patternfly/react-core/dist/esm/components/Text/Text.js";
import RuleFeedback, { feedback } from './RuleFeedback';
import Markdown from '../Markdown';
import { totalRiskMeta } from './constants';
import RiskDescription from './RiskDescription';
import { riskOfChangeMeta } from './RiskOfChangeIcon';
import "../../ReportDetails/./index.css";

var ReportDetails = function ReportDetails(_ref) {
  var details = _ref.details,
      ruleId = _ref.ruleId,
      totalRisk = _ref.totalRisk,
      riskOfChange = _ref.riskOfChange,
      showRiskDescription = _ref.showRiskDescription,
      definitions = _ref.definitions,
      createdAt = _ref.createdAt,
      userVote = _ref.userVote,
      title = _ref.title,
      actions = _ref.actions,
      onFeedbackChanged = _ref.onFeedbackChanged;
  return /*#__PURE__*/React.createElement(Grid, {
    className: "ins-c-rule__report-detail",
    hasGutter: true,
    gutter: "md"
  }, title && actions && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(GridItem, {
    span: 8
  }, /*#__PURE__*/React.createElement(Stack, null, /*#__PURE__*/React.createElement(StackItem, null, title), createdAt && /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(Text, null, "Published date: ", createdAt)))), /*#__PURE__*/React.createElement(GridItem, {
    span: 4,
    className: "ins-c-rule__report-detail-actions"
  }, actions)), /*#__PURE__*/React.createElement(GridItem, {
    span: 8
  }, /*#__PURE__*/React.createElement(Stack, {
    hasGutter: true,
    gutter: "md"
  }, /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Markdown, {
    template: details,
    definitions: definitions
  }))), /*#__PURE__*/React.createElement(StackItem, null, onFeedbackChanged && /*#__PURE__*/React.createElement(RuleFeedback, {
    userVote: userVote,
    ruleId: ruleId,
    onFeedbackChanged: onFeedbackChanged
  })))), /*#__PURE__*/React.createElement(GridItem, {
    span: 4
  }, /*#__PURE__*/React.createElement(Stack, {
    hasGutter: true,
    gutter: "md"
  }, /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(Stack, null, /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h1",
    className: "ins-c-rule__risk-detail-title",
    size: "md"
  }, "Total risk")), /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(RiskDescription, {
    riskValue: totalRisk,
    riskMeta: totalRiskMeta,
    showDescription: showRiskDescription
  })))), riskOfChange > 0 && riskOfChange < 5 && /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(Stack, null, /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(Title, {
    headingLevel: "h1",
    className: "ins-c-rule__risk-detail-title",
    size: "md"
  }, "Risk of change")), /*#__PURE__*/React.createElement(StackItem, null, /*#__PURE__*/React.createElement(RiskDescription, {
    riskValue: riskOfChange,
    riskMeta: riskOfChangeMeta,
    showDescription: showRiskDescription
  })))))));
};

ReportDetails.propTypes = {
  details: PropTypes.string,
  ruleId: PropTypes.string,
  totalRisk: PropTypes.number,
  riskOfChange: PropTypes.number,
  userVote: PropTypes.oneOf(Object.values(feedback)),
  showRiskDescription: PropTypes.bool,
  definitions: PropTypes.object,
  createdAt: PropTypes.node,
  title: PropTypes.node,
  actions: PropTypes.node,
  onFeedbackChanged: PropTypes.func
};
ReportDetails.defaultProps = {
  showRiskDescription: true,
  userVote: 0
};
export default ReportDetails;