"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var global_breakpoint_md_1 = __importDefault(require("@patternfly/react-tokens/dist/js/global_breakpoint_md"));
var TextFilter_1 = __importDefault(require("./TextFilter"));
var conditionalFilterConstants_1 = require("./conditionalFilterConstants");
var prop_types_1 = __importDefault(require("prop-types"));
require("./conditional-filter.css");
var react_2 = require("react");
var classnames_1 = __importDefault(require("classnames"));
var ConditionalFilter = (function (_super) {
    __extends(ConditionalFilter, _super);
    function ConditionalFilter(props) {
        var _this = this;
        if (!props.useMobileLayout) {
            console.warn("The prop \"useMobileLayout\" is set to false. You are using an outdated mobile layout of conditional filter.\n            Please switch to new layout by adding \"useMobileLayout={true}\" prop to the PrimaryToolbar or ConditionalFilter directly.\n            The new mobile layout will become the default in next minor release.");
        }
        _this = _super.call(this, props) || this;
        _this.dropdownToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        _this.onChange = function (_e, value) {
            _this.setState({
                stateValue: value,
            });
        };
        _this.getWrapper = function () {
            return _this.props.useMobileLayout && _this.state.isMobile
                ? function (props) { return react_1.default.createElement(react_core_1.ToolbarToggleGroup, __assign({}, props, { breakpoint: "md", toggleIcon: react_1.default.createElement(react_icons_1.FilterIcon, null) })); }
                : react_2.Fragment;
        };
        _this.updateFilterViewport = function (width) { return width <= _this.breakpointConstant; };
        _this.breakpointConstant = parseInt(global_breakpoint_md_1.default.value.replace('px', ''));
        _this.state = {
            isOpen: false,
            stateValue: undefined,
            isMobile: _this.updateFilterViewport(window.innerWidth),
        };
        return _this;
    }
    ConditionalFilter.prototype.componentDidMount = function () {
        var _this = this;
        this.resizeListener = window.addEventListener('resize', function (event) {
            _this.setState(function (prev) { return (__assign(__assign({}, prev), { isMobile: _this.updateFilterViewport(event.target.innerWidth) })); });
        });
    };
    ConditionalFilter.prototype.componentWillUnmount = function () {
        if (this.resizeListener) {
            window.removeEventListener(this.resizeListener);
        }
    };
    ConditionalFilter.prototype.render = function () {
        var _this = this;
        var _a = this.props, items = _a.items, value = _a.value, onChange = _a.onChange, placeholder = _a.placeholder, hideLabel = _a.hideLabel, isDisabled = _a.isDisabled, useMobileLayout = _a.useMobileLayout, props = __rest(_a, ["items", "value", "onChange", "placeholder", "hideLabel", "isDisabled", "useMobileLayout"]);
        var _b = this.state, isOpen = _b.isOpen, stateValue = _b.stateValue, isMobile = _b.isMobile;
        var currentValue = onChange ? value : stateValue;
        var activeItem = items && items.length && (items.find(function (item, key) { return item.value === currentValue || key === currentValue; }) || items[0]);
        var onChangeCallback = onChange || this.onChange;
        var ActiveComponent = activeItem && (conditionalFilterConstants_1.typeMapper[activeItem.type] || conditionalFilterConstants_1.typeMapper.text);
        var capitalize = function (string) { return string[0].toUpperCase() + string.substring(1); };
        var shouldRenderNewLayout = useMobileLayout && isMobile;
        var Wrapper = this.getWrapper();
        return (react_1.default.createElement(Wrapper, null,
            useMobileLayout && isMobile && (react_1.default.createElement(react_core_1.ToolbarGroup, { className: "ins-c-conditional-filter mobile" }, items.map(function (activeItem, key) {
                var ActiveComponent = activeItem && (conditionalFilterConstants_1.typeMapper[activeItem.type] || conditionalFilterConstants_1.typeMapper.text);
                return (react_1.default.createElement(react_core_1.ToolbarItem, { key: key },
                    react_1.default.createElement(ActiveComponent, __assign({}, (activeItem.type !== conditionalFilterConstants_1.conditionalFilterType.custom && {
                        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
                        id: (activeItem.filterValues && activeItem.filterValues.id) || currentValue,
                    }), activeItem.filterValues))));
            }))),
            !shouldRenderNewLayout && (react_1.default.createElement(react_2.Fragment, null, !items || (items && items.length <= 0) ? (react_1.default.createElement("div", { className: (0, classnames_1.default)('ins-c-conditional-filter', {
                    desktop: useMobileLayout,
                }) },
                react_1.default.createElement(TextFilter_1.default, __assign({}, props, { value: currentValue, onChange: function (e) { return onChangeCallback(e, e.target.value); }, placeholder: placeholder, "widget-type": "InsightsInput" })))) : (react_1.default.createElement(react_core_1.Split, { className: (0, classnames_1.default)('ins-c-conditional-filter', {
                    desktop: useMobileLayout,
                }) },
                items.length > 1 && (react_1.default.createElement(react_core_1.SplitItem, null,
                    react_1.default.createElement(react_core_1.Dropdown, { className: "ins-c-conditional-filter__group", onSelect: function () { return _this.dropdownToggle(false); }, isOpen: isOpen, ouiaId: "ConditionalFilter", toggle: react_1.default.createElement(react_core_1.DropdownToggle, { "aria-label": "Conditional filter", onToggle: this.dropdownToggle, isDisabled: isDisabled, className: hideLabel ? 'ins-c-conditional-filter__no-label' : '', ouiaId: "ConditionalFilter" },
                            react_1.default.createElement(react_icons_1.FilterIcon, { size: "sm" }),
                            !hideLabel && (react_1.default.createElement("span", { className: "ins-c-conditional-filter__value-selector" }, activeItem && capitalize(activeItem.label)))), dropdownItems: items.map(function (item, key) { return (react_1.default.createElement(react_core_1.DropdownItem, { key: item.id ? "".concat(item.id, "-dropdown") : key, component: "button", ouiaId: item.label, onClick: function (e) { return onChangeCallback(e, item.value || key, item); }, isHovered: activeItem.label === item.label }, capitalize(item.label))); }) }))),
                ActiveComponent && (react_1.default.createElement(react_core_1.SplitItem, { isFilled: true },
                    react_1.default.createElement(ActiveComponent, __assign({}, (activeItem.type !== conditionalFilterConstants_1.conditionalFilterType.custom && {
                        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
                        id: (activeItem.filterValues && activeItem.filterValues.id) || currentValue,
                    }), activeItem.filterValues))))))))));
    };
    return ConditionalFilter;
}(react_1.Component));
var TextInputProps = {
    value: prop_types_1.default.string,
    placeholder: prop_types_1.default.string,
    onChange: prop_types_1.default.func,
};
ConditionalFilter.propTypes = __assign(__assign({ hideLabel: prop_types_1.default.bool, items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        id: prop_types_1.default.string,
        label: prop_types_1.default.node,
        value: prop_types_1.default.string,
        type: prop_types_1.default.oneOf(['text', 'checkbox', 'radio', 'custom', 'group']),
        filterValues: prop_types_1.default.oneOfType([
            prop_types_1.default.shape(TextInputProps),
            prop_types_1.default.shape(__assign(__assign({}, TextInputProps), { value: prop_types_1.default.oneOfType([
                    prop_types_1.default.string,
                    prop_types_1.default.arrayOf(prop_types_1.default.oneOfType([
                        prop_types_1.default.string,
                        prop_types_1.default.shape({
                            label: prop_types_1.default.node,
                            value: prop_types_1.default.string,
                        }),
                    ])),
                    prop_types_1.default.shape((_a = {},
                        _a[prop_types_1.default.string] = prop_types_1.default.any,
                        _a)),
                ]), items: prop_types_1.default.arrayOf(prop_types_1.default.shape({
                    label: prop_types_1.default.node,
                    value: prop_types_1.default.string,
                })) })),
        ]),
    })) }, TextInputProps), { id: prop_types_1.default.string, isDisabled: prop_types_1.default.bool, useMobileLayout: prop_types_1.default.bool });
ConditionalFilter.defaultProps = {
    value: '',
    items: [],
    hideLabel: false,
    isDisabled: false,
    id: 'default-input',
    useMobileLayout: false,
};
exports.default = ConditionalFilter;
//# sourceMappingURL=ConditionalFilter.js.map