"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dateByType = exports.dateStringByType = exports.addTooltip = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var second = 1000;
var minute = second * 60;
var hour = minute * 60;
var day = hour * 24;
var month = day * 30;
var year = day * 365;
var formatTime = function (number, unit) { return "".concat(number, " ").concat(number > 1 ? "".concat(unit, "s") : unit, " ago"); };
var relativeTimeTable = [
    { rightBound: Infinity, description: function (date) { return formatTime(Math.round(date / year), 'year'); } },
    { rightBound: year, description: function (date) { return formatTime(Math.round(date / month), 'month'); } },
    { rightBound: month, description: function (date) { return formatTime(Math.round(date / day), 'day'); } },
    { rightBound: day, description: function (date) { return formatTime(Math.round(date / hour), 'hour'); } },
    { rightBound: hour, description: function (date) { return formatTime(Math.round(date / minute), 'minute'); } },
    { rightBound: minute, description: function () { return 'Just now'; } },
];
var exact = function (value) { return value.toUTCString().split(',')[1].slice(0, -7).trim(); };
var addTooltip = function (date, element, tooltipProps, extraTitle) {
    if (extraTitle === void 0) { extraTitle = ''; }
    return (react_1.default.createElement(react_core_1.Tooltip, __assign({}, tooltipProps, { content: react_1.default.createElement("div", null,
            extraTitle,
            date) }), element));
};
exports.addTooltip = addTooltip;
var dateStringByType = function (type) {
    return ({
        exact: function (date) { return exact(date) + ' UTC'; },
        onlyDate: function (date) { return exact(date).slice(0, -6); },
        relative: function (date) {
            return relativeTimeTable.reduce(function (acc, i) { return (i.rightBound > Date.now() - date ? i.description(Date.now() - date) : acc); }, exact(date));
        },
        invalid: function () { return 'Invalid date'; },
    }[type]);
};
exports.dateStringByType = dateStringByType;
var dateByType = function (type, tooltipProps, extraTitle) {
    return ({
        exact: function (date) { return (0, exports.dateStringByType)(type)(date); },
        onlyDate: function (date) { return (0, exports.dateStringByType)(type)(date); },
        relative: function (date) { return (0, exports.addTooltip)((0, exports.dateStringByType)('exact')(date), react_1.default.createElement("span", null, (0, exports.dateStringByType)(type)(date)), tooltipProps, extraTitle); },
        invalid: function () { return 'Invalid date'; },
    }[type]);
};
exports.dateByType = dateByType;
//# sourceMappingURL=helper.js.map