"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dropDirection = void 0;
var react_1 = __importStar(require("react"));
var PaginationNext_1 = __importDefault(require("./PaginationNext"));
var prop_types_1 = __importDefault(require("prop-types"));
exports.dropDirection = {
    up: 'up',
    down: 'down',
};
var pager = [10, 15, 20, 25, 50];
var Pagination = (function (_super) {
    __extends(Pagination, _super);
    function Pagination() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.setPage = function (page, debounce) {
            var currPage = _this.props.page;
            var perPage = _this.props.itemsPerPage || pager[0];
            var maxPage = Math.ceil(_this.props.numberOfItems / perPage);
            page = isNaN(page) ? currPage : page;
            page = page > maxPage ? maxPage : page < 0 ? 0 : page;
            _this.props.hasOwnProperty('onSetPage') && _this.props.onSetPage(page, debounce);
        };
        return _this;
    }
    Pagination.prototype.render = function () {
        var _this = this;
        var _a = this.props, page = _a.page, onSetPage = _a.onSetPage, numberOfItems = _a.numberOfItems, itemsPerPage = _a.itemsPerPage, perPageOptions = _a.perPageOptions, onPerPageSelect = _a.onPerPageSelect, onFirstPage = _a.onFirstPage, onLastPage = _a.onLastPage, onPreviousPage = _a.onPreviousPage, onNextPage = _a.onNextPage, props = __rest(_a, ["page", "onSetPage", "numberOfItems", "itemsPerPage", "perPageOptions", "onPerPageSelect", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);
        var pagerOptions = perPageOptions || pager;
        var perPage = itemsPerPage || pagerOptions[0];
        var lastPage = Math.ceil(numberOfItems / perPage);
        var lastIndex = numberOfItems === 0 ? 0 : page === lastPage ? numberOfItems : page * perPage;
        var firstIndex = numberOfItems === 0 ? 0 : (page - 1) * perPage + 1;
        return (react_1.default.createElement(PaginationNext_1.default, __assign({}, props, { itemCount: this.props.numberOfItems, className: "ins-c-pagination-next", itemsStart: firstIndex, itemsEnd: lastIndex, lastPage: lastPage || 1, dropDirection: this.props.direction, onFirstPage: onFirstPage, onLastPage: onLastPage, onPreviousPage: onPreviousPage, onNextPage: onNextPage, perPage: perPage, onSetPerPage: function (_event, value) { return _this.props.onPerPageSelect(value); }, page: this.props.page, setPage: function (event, page) { return _this.setPage(page, event.currentTarget.tagName === 'INPUT'); }, perPageOptions: pagerOptions.map(function (value) { return ({
                title: value,
                value: value,
            }); }) })));
    };
    return Pagination;
}(react_1.Component));
Pagination.propTypes = {
    direction: prop_types_1.default.oneOf(Object.keys(exports.dropDirection)),
    viewType: prop_types_1.default.string,
    itemsPerPage: prop_types_1.default.number,
    perPageOptions: prop_types_1.default.arrayOf(prop_types_1.default.number),
    numberOfItems: prop_types_1.default.number.isRequired,
    onSetPage: prop_types_1.default.func,
    onPerPageSelect: prop_types_1.default.func,
    onFirstPage: prop_types_1.default.func,
    onLastPage: prop_types_1.default.func,
    onPreviousPage: prop_types_1.default.func,
    onNextPage: prop_types_1.default.func,
    page: prop_types_1.default.number,
};
Pagination.defaultProps = {
    page: 1,
};
exports.default = Pagination;
//# sourceMappingURL=Pagination.js.map