"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_icons_1 = require("@patternfly/react-icons");
var react_core_1 = require("@patternfly/react-core");
var PaginationNav = (function (_super) {
    __extends(PaginationNav, _super);
    function PaginationNav() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isOpen: false,
        };
        _this.onSelect = function () {
            _this.setState({
                isOpen: !_this.state.isOpen,
            });
        };
        _this.onToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        return _this;
    }
    PaginationNav.prototype.render = function () {
        var _a = this.props, itemsTitle = _a.itemsTitle, itemsStart = _a.itemsStart, itemsEnd = _a.itemsEnd, widtgetId = _a.widtgetId, dropDirection = _a.dropDirection, onSetPerPage = _a.onSetPerPage, itemCount = _a.itemCount, perPageOptions = _a.perPageOptions, className = _a.className, perPage = _a.perPage, props = __rest(_a, ["itemsTitle", "itemsStart", "itemsEnd", "widtgetId", "dropDirection", "onSetPerPage", "itemCount", "perPageOptions", "className", "perPage"]);
        var isOpen = this.state.isOpen;
        return (react_1.default.createElement("div", __assign({ className: "pf-c-options-menu ".concat(className) }, props),
            react_1.default.createElement("span", { id: "".concat(widtgetId, "-label"), hidden: true }, "Items per page:"),
            react_1.default.createElement("div", { className: "pf-c-options-menu__toggle pf-m-text pf-m-plain" },
                react_1.default.createElement(react_core_1.Dropdown, { direction: dropDirection, isPlain: true, isOpen: isOpen, onSelect: this.onSelect, dropdownItems: perPageOptions.map(function (_a) {
                        var title = _a.title, value = _a.value;
                        return (react_1.default.createElement(react_core_1.DropdownItem, { onClick: function (event) { return value !== perPage && onSetPerPage(event, value); }, key: value, component: "button" },
                            title,
                            value === perPage && react_1.default.createElement(react_icons_1.CheckIcon, { className: "pf-c-options-menu__menu-item-icon", size: "md" })));
                    }), toggle: react_1.default.createElement(react_core_1.DropdownToggle, { onToggle: this.onToggle, toggleIndicator: null, className: "pf-c-options-menu__toggle-button" },
                        react_1.default.createElement("span", { className: "pf-c-options-menu__toggle-text" },
                            react_1.default.createElement("b", null,
                                itemsStart,
                                " - ",
                                itemsEnd),
                            ' ',
                            "of ",
                            react_1.default.createElement("b", null, itemCount),
                            " ",
                            itemsTitle),
                        dropDirection === 'up' ? react_1.default.createElement(react_icons_1.CaretUpIcon, null) : react_1.default.createElement(react_icons_1.CaretDownIcon, null)) }))));
    };
    return PaginationNav;
}(react_1.Component));
PaginationNav.propTypes = {
    itemsTitle: prop_types_1.default.string,
    itemsStart: prop_types_1.default.number,
    itemsEnd: prop_types_1.default.number,
    dropDirection: prop_types_1.default.string,
    widtgetId: prop_types_1.default.string,
    onSetPerPage: prop_types_1.default.func,
    itemCount: prop_types_1.default.number.isRequired,
    perPage: prop_types_1.default.number,
    perPageOptions: prop_types_1.default.arrayOf(prop_types_1.default.shape({
        title: prop_types_1.default.node,
        value: prop_types_1.default.number,
    })),
    className: prop_types_1.default.string,
};
PaginationNav.defaultProps = {
    itemsTitle: 'items',
    dropDirection: 'up',
    className: '',
};
exports.default = PaginationNav;
//# sourceMappingURL=PaginationMenu.js.map