"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var PaginationNav = function (_a) {
    var lastPage = _a.lastPage, setPage = _a.setPage, pageTitle = _a.pageTitle, amountOfPages = _a.amountOfPages, page = _a.page, onFirstPage = _a.onFirstPage, onLastPage = _a.onLastPage, onPreviousPage = _a.onPreviousPage, onNextPage = _a.onNextPage, props = __rest(_a, ["lastPage", "setPage", "pageTitle", "amountOfPages", "page", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);
    return (react_1.default.createElement("nav", __assign({ className: "pf-c-pagination__nav", "aria-label": "Pagination" }, props),
        react_1.default.createElement(react_core_1.Button, { variant: react_core_1.ButtonVariant.plain, isDisabled: page === 1, "aria-label": "Go to first page", "data-action": "first-page", onClick: function (event) {
                onFirstPage(event);
                setPage(event, 1);
            } },
            react_1.default.createElement(react_icons_1.AngleDoubleLeftIcon, null)),
        react_1.default.createElement(react_core_1.Button, { variant: react_core_1.ButtonVariant.plain, isDisabled: page === 1, "aria-label": "Go to previous page", "data-action": "previous-page", onClick: function (event) {
                onPreviousPage(event, page - 1);
                setPage(event, page - 1);
            } },
            react_1.default.createElement(react_icons_1.AngleLeftIcon, null)),
        react_1.default.createElement("div", { className: "pf-c-pagination__nav-page-select", "aria-label": "Current page ".concat(page, " of ").concat(lastPage) },
            react_1.default.createElement(react_core_1.TextInput, { className: "pf-c-form-control", "aria-label": "Current page", type: "number", min: "1", "data-action": "set-page", max: amountOfPages, style: { width: "".concat(lastPage.toString().length, "rem"), minWidth: '3rem' }, isReadOnly: amountOfPages === 1, value: page, onChange: function (value, event) {
                    setPage(event, value === '' ? NaN : Number(value));
                } }),
            react_1.default.createElement("span", { "aria-hidden": "true" },
                "of ",
                lastPage,
                " ",
                pageTitle)),
        react_1.default.createElement(react_core_1.Button, { variant: react_core_1.ButtonVariant.plain, isDisabled: page === lastPage, "aria-label": "Go to next page", "data-action": "next-page", onClick: function (event) {
                onNextPage(event, page + 1);
                setPage(event, page + 1);
            } },
            react_1.default.createElement(react_icons_1.AngleRightIcon, null)),
        react_1.default.createElement(react_core_1.Button, { variant: react_core_1.ButtonVariant.plain, isDisabled: page === lastPage, "aria-label": "Go to last page", "data-action": "last-page", onClick: function (event) {
                onLastPage(event);
                setPage(event, lastPage);
            } },
            react_1.default.createElement(react_icons_1.AngleDoubleRightIcon, null))));
};
PaginationNav.propTypes = {
    lastPage: prop_types_1.default.number,
    page: prop_types_1.default.number,
    pageTitle: prop_types_1.default.string,
    setPage: prop_types_1.default.func,
    amountOfPages: prop_types_1.default.number,
    onFirstPage: prop_types_1.default.func,
    onLastPage: prop_types_1.default.func,
    onPreviousPage: prop_types_1.default.func,
    onNextPage: prop_types_1.default.func,
};
PaginationNav.defaultProps = {
    pageTitle: 'pages',
    onFirstPage: function () { return undefined; },
    onLastPage: function () { return undefined; },
    onPreviousPage: function () { return undefined; },
    onNextPage: function () { return undefined; },
};
exports.default = PaginationNav;
//# sourceMappingURL=PaginationNav.js.map