"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var react_1 = __importDefault(require("react"));
var consts_1 = require("./consts");
var Shield = function (_a) {
    var _b;
    var _c = _a.impact, impact = _c === void 0 ? 'N/A' : _c, _d = _a.hasLabel, hasLabel = _d === void 0 ? false : _d, _e = _a.size, size = _e === void 0 ? 'sm' : _e, _f = _a.hasTooltip, hasTooltip = _f === void 0 ? true : _f;
    var attributes = (_b = consts_1.impactList === null || consts_1.impactList === void 0 ? void 0 : consts_1.impactList[impact]) !== null && _b !== void 0 ? _b : consts_1.impactList.Unknown;
    var badgeProps = {
        'aria-hidden': 'false',
        'aria-label': attributes.title,
        color: attributes.color,
        size: size,
    };
    var badge = attributes.title === 'Unknown' ? react_1.default.createElement(react_icons_1.QuestionIcon, __assign({}, badgeProps)) : react_1.default.createElement(react_icons_1.SecurityIcon, __assign({}, badgeProps));
    var body = (react_1.default.createElement("span", null,
        badge,
        " ",
        hasLabel && attributes.title));
    return (react_1.default.createElement("span", null, hasTooltip ? (react_1.default.createElement(react_core_1.Tooltip, { content: react_1.default.createElement("div", null, attributes.message), position: 'bottom' }, body)) : (body)));
};
exports.default = Shield;
//# sourceMappingURL=Shield.js.map