"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var react_core_1 = require("@patternfly/react-core");
var prop_types_1 = require("prop-types");
var react_table_1 = require("@patternfly/react-table");
var EmptyTable_1 = require("../EmptyTable");
var TableToolbar_1 = require("../TableToolbar");
var PrimaryToolbar_1 = require("../PrimaryToolbar");
var Skeleton_1 = require("../Skeleton");
var SkeletonTable_1 = require("../SkeletonTable");
var TableWithFilter = function (_a) {
    var rows = _a.rows, onSelect = _a.onSelect, selected = _a.selected, onUpdateData = _a.onUpdateData, pagination = _a.pagination, loaded = _a.loaded, calculateChecked = _a.calculateChecked, unique = _a.unique, filters = _a.filters, primaryToolbarProps = _a.primaryToolbarProps, children = _a.children, title = _a.title, systemName = _a.systemName, columns = _a.columns, tableProps = _a.tableProps, entityName = _a.entityName, bulkSelect = _a.bulkSelect;
    var onRowSelect = function (_a) {
        var isSelected = _a.isSelected, rowId = _a.rowId;
        var currRow = rows === null || rows === void 0 ? void 0 : rows[rowId];
        if (currRow) {
            onSelect(isSelected ? __spreadArray(__spreadArray([], selected, true), [currRow], false) : selected.filter(function (_a) {
                var id = _a.id;
                return id !== currRow.id;
            }));
        }
    };
    return (react_1.default.createElement(react_1.Fragment, null,
        onUpdateData && (react_1.default.createElement(PrimaryToolbar_1.PrimaryToolbar, __assign({}, (onSelect &&
            pagination && {
            bulkSelect: __assign({ count: selected === null || selected === void 0 ? void 0 : selected.length, onSelect: function (isSelected) {
                    if (isSelected) {
                        onSelect(unique === null || unique === void 0 ? void 0 : unique(__spreadArray(__spreadArray([], rows, true), selected, true)));
                    }
                    else {
                        onSelect(selected.filter(function (_a) {
                            var id = _a.id;
                            return !rows.find(function (_a) {
                                var rowId = _a.id;
                                return rowId === id;
                            });
                        }));
                    }
                }, checked: loaded && (calculateChecked === null || calculateChecked === void 0 ? void 0 : calculateChecked(rows, selected)), items: [
                    {
                        title: 'Select none (0)',
                        onClick: function () { return onSelect([]); },
                    },
                    __assign({}, (loaded && (rows === null || rows === void 0 ? void 0 : rows.length) > 0
                        ? {
                            title: "Select page (".concat(rows.length, ")"),
                            onClick: function () { return onSelect(unique(__spreadArray(__spreadArray([], rows, true), selected, true))); },
                        }
                        : {})),
                ] }, (bulkSelect || {})),
        }), (filters && {
            filterConfig: {
                items: filters,
            },
        }), { pagination: loaded ? (__assign(__assign({}, (pagination || {})), { itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count, onSetPage: function (_e, page) { return onUpdateData(__assign(__assign({}, pagination), { page: page })); }, onPerPageSelect: function (_e, perPage) { return onUpdateData(__assign(__assign({}, pagination), { page: 1, perPage: perPage })); } })) : (react_1.default.createElement(Skeleton_1.Skeleton, { size: "lg" })) }, primaryToolbarProps))),
        children,
        loaded ? (react_1.default.createElement(react_table_1.Table, __assign({ "aria-label": title || "".concat(systemName, " ").concat(entityName), variant: "compact", className: "ins-c-tag-modal__table", cells: columns, rows: (rows === null || rows === void 0 ? void 0 : rows.length)
                ? rows
                : [
                    {
                        cells: [
                            {
                                title: (react_1.default.createElement(EmptyTable_1.EmptyTable, null,
                                    react_1.default.createElement(react_core_1.Bullseye, null,
                                        react_1.default.createElement(react_core_1.EmptyState, { variant: react_core_1.EmptyStateVariant.full },
                                            react_1.default.createElement(react_core_1.Title, { headingLevel: "h5", size: "lg" },
                                                "No ",
                                                entityName,
                                                " found"),
                                            react_1.default.createElement(react_core_1.EmptyStateBody, null,
                                                "This filter criteria matches no ",
                                                entityName,
                                                ". ",
                                                react_1.default.createElement("br", null),
                                                " Try changing your filter settings."))))),
                                props: {
                                    colSpan: columns.length,
                                },
                            },
                        ],
                    },
                ] }, (onSelect &&
            (rows === null || rows === void 0 ? void 0 : rows.length) && {
            onSelect: function (_event, isSelected, rowId) { return onRowSelect({ isSelected: isSelected, rowId: rowId }); },
        }), tableProps),
            react_1.default.createElement(react_table_1.TableHeader, null),
            react_1.default.createElement(react_table_1.TableBody, null))) : (react_1.default.createElement(SkeletonTable_1.SkeletonTable, { columns: columns, rowSize: (pagination === null || pagination === void 0 ? void 0 : pagination.perPage) || 10 })),
        onUpdateData && pagination && loaded && (react_1.default.createElement(TableToolbar_1.TableToolbar, { isFooter: true, className: "ins-c-inventory__table--toolbar" },
            react_1.default.createElement(react_core_1.Pagination, { itemCount: pagination === null || pagination === void 0 ? void 0 : pagination.count, perPage: pagination === null || pagination === void 0 ? void 0 : pagination.perPage, page: (pagination === null || pagination === void 0 ? void 0 : pagination.page) || 0, variant: "bottom", onSetPage: function (_event, page) { return onUpdateData(__assign(__assign({}, pagination), { page: page })); }, onPerPageSelect: function (_event, perPage) { return onUpdateData(__assign(__assign({}, pagination), { page: 1, perPage: perPage })); } })))));
};
TableWithFilter.propTypes = {
    entityName: prop_types_1.PropTypes.string,
    loaded: prop_types_1.PropTypes.bool,
    systemName: prop_types_1.PropTypes.string,
    rows: prop_types_1.PropTypes.array,
    selected: prop_types_1.PropTypes.array,
    columns: prop_types_1.PropTypes.array,
    filters: prop_types_1.PropTypes.array,
    pagination: prop_types_1.PropTypes.shape({
        count: prop_types_1.PropTypes.number,
        page: prop_types_1.PropTypes.number,
        perPage: prop_types_1.PropTypes.number,
    }),
    primaryToolbarProps: prop_types_1.PropTypes.object,
    tableProps: prop_types_1.PropTypes.object,
    children: prop_types_1.PropTypes.node,
    title: prop_types_1.PropTypes.node,
    calculateChecked: prop_types_1.PropTypes.func,
    unique: prop_types_1.PropTypes.func,
    onSelect: prop_types_1.PropTypes.func,
    onUpdateData: prop_types_1.PropTypes.func,
    bulkSelect: prop_types_1.PropTypes.any,
};
TableWithFilter.defaultProps = {
    entityName: 'tags',
};
exports.default = TableWithFilter;
//# sourceMappingURL=TableWithFilter.js.map