"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var prop_types_1 = __importDefault(require("prop-types"));
require("./tagModal.css");
var react_core_1 = require("@patternfly/react-core");
var classnames_1 = __importDefault(require("classnames"));
var TableWithFilter_1 = __importDefault(require("./TableWithFilter"));
var calculateChecked = function (rows, selected) {
    if (rows === void 0) { rows = []; }
    return rows.every(function (_a) {
        var id = _a.id;
        return selected && selected.find(function (_a) {
            var selectedId = _a.id;
            return selectedId === id;
        });
    })
        ? rows.length > 0
        : rows.some(function (_a) {
            var id = _a.id;
            return selected && selected.find(function (_a) {
                var selectedId = _a.id;
                return selectedId === id;
            });
        }) && null;
};
var unique = function (arr) { return arr.filter(function (_a, index, arr) {
    var id = _a.id;
    return arr.findIndex(function (_a) {
        var currId = _a.id;
        return currId === id;
    }) === index;
}); };
var TagModal = (function (_super) {
    __extends(TagModal, _super);
    function TagModal() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            selectedTab: 0,
        };
        _this.handleTabClick = function (_event, tabIndex) {
            _this.setState({ activeTabKey: tabIndex });
        };
        _this.renderTable = function (rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData, bulkSelect) { return (react_1.default.createElement(TableWithFilter_1.default, __assign({}, _this.props, { rows: rows, pagination: pagination, loaded: loaded, calculateChecked: calculateChecked, unique: unique, filters: filters, title: _this.props.title, systemName: _this.props.systemName, columns: columns, onSelect: onSelect, onUpdateData: onUpdateData, selected: selected, bulkSelect: bulkSelect }), _this.props.children)); };
        return _this;
    }
    TagModal.prototype.render = function () {
        var _this = this;
        var _a = this.props, className = _a.className, title = _a.title, systemName = _a.systemName, toggleModal = _a.toggleModal, isOpen = _a.isOpen, rows = _a.rows, columns = _a.columns, children = _a.children, pagination = _a.pagination, loaded = _a.loaded, filters = _a.filters, onApply = _a.onApply, tabNames = _a.tabNames, onSelect = _a.onSelect, onUpdateData = _a.onUpdateData, selected = _a.selected, tableProps = _a.tableProps, bulkSelect = _a.bulkSelect, props = __rest(_a, ["className", "title", "systemName", "toggleModal", "isOpen", "rows", "columns", "children", "pagination", "loaded", "filters", "onApply", "tabNames", "onSelect", "onUpdateData", "selected", "tableProps", "bulkSelect"]);
        var isTabbed = Array.isArray(tabNames);
        return (react_1.default.createElement(react_core_1.Modal, __assign({}, props, { className: (0, classnames_1.default)('ins-c-tag-modal', className), isOpen: isOpen, title: title || "Tags for ".concat(systemName), onClose: function (e) { return toggleModal(e, false); }, variant: "medium" }, (onApply && {
            actions: [
                react_1.default.createElement(react_core_1.Button, { key: "confirm", variant: "primary", isDisabled: isTabbed ? Object.values(selected || {}).every(function (values) { return !values || (values === null || values === void 0 ? void 0 : values.length) === 0; }) : !selected || (selected === null || selected === void 0 ? void 0 : selected.length) === 0, onClick: function (e) {
                        onApply();
                        toggleModal(e, true);
                    } },
                    "Apply ",
                    isTabbed ? 'selected' : 'tags'),
                react_1.default.createElement(react_core_1.Button, { key: "cancel", variant: "link", onClick: function (e) { return toggleModal(e, false); } }, "Cancel"),
            ],
        })), isTabbed ? (react_1.default.createElement(react_core_1.Tabs, { activeKey: this.state.activeTabKey, onSelect: this.handleTabClick }, tabNames.map(function (item, key) { return (react_1.default.createElement(react_core_1.Tab, { key: key, eventKey: key, title: react_1.default.createElement(react_core_1.TabTitleText, null,
                "All ",
                item) }, _this.renderTable(rows === null || rows === void 0 ? void 0 : rows[key], columns === null || columns === void 0 ? void 0 : columns[key], pagination === null || pagination === void 0 ? void 0 : pagination[key], loaded === null || loaded === void 0 ? void 0 : loaded[key], filters === null || filters === void 0 ? void 0 : filters[key], selected === null || selected === void 0 ? void 0 : selected[key], onSelect === null || onSelect === void 0 ? void 0 : onSelect[key], onUpdateData === null || onUpdateData === void 0 ? void 0 : onUpdateData[key], bulkSelect === null || bulkSelect === void 0 ? void 0 : bulkSelect[key]))); }))) : (this.renderTable(rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData, bulkSelect))));
    };
    return TagModal;
}(react_1.Component));
TagModal.propTypes = {
    tabNames: prop_types_1.default.arrayOf(prop_types_1.default.string),
    loaded: prop_types_1.default.oneOfType([prop_types_1.default.bool, prop_types_1.default.arrayOf(prop_types_1.default.bool)]),
    title: prop_types_1.default.string,
    systemName: prop_types_1.default.string,
    isOpen: prop_types_1.default.bool,
    toggleModal: prop_types_1.default.func,
    rows: prop_types_1.default.array,
    columns: prop_types_1.default.array,
    className: prop_types_1.default.string,
    tableProps: prop_types_1.default.shape((_a = {},
        _a[prop_types_1.default.string] = prop_types_1.default.any,
        _a)),
    onSelect: prop_types_1.default.oneOfType([prop_types_1.default.func, prop_types_1.default.arrayOf(prop_types_1.default.func)]),
    onUpdateData: prop_types_1.default.oneOfType([prop_types_1.default.func, prop_types_1.default.arrayOf(prop_types_1.default.func)]),
    bulkSelect: prop_types_1.default.oneOfType([prop_types_1.default.any, prop_types_1.default.arrayOf(prop_types_1.default.any)]),
    pagination: prop_types_1.default.oneOfType([TableWithFilter_1.default.propTypes.pagination, prop_types_1.default.arrayOf(TableWithFilter_1.default.propTypes.pagination)]),
    primaryToolbarProps: prop_types_1.default.shape((_b = {},
        _b[prop_types_1.default.string] = prop_types_1.default.any,
        _b)),
    selected: prop_types_1.default.array,
    children: prop_types_1.default.node,
    filters: prop_types_1.default.any,
    onApply: prop_types_1.default.func,
};
TagModal.defaultProps = {
    loaded: false,
    isOpen: false,
    toggleModal: function () { return undefined; },
    columns: [{ title: 'Name' }, { title: 'Tag source' }],
    onUpdateData: function () { return undefined; },
    rows: [],
    tableProps: {},
    pagination: { count: 10 },
};
exports.default = TagModal;
//# sourceMappingURL=TagModal.js.map