var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import React, { useState, useRef, Fragment } from 'react';
import classnames from 'classnames';
import { Dropdown, DropdownItem, DropdownToggle, DropdownToggleCheckbox, Checkbox, } from '@patternfly/react-core';
import { getDefaultOUIAId } from '@patternfly/react-core/';
import './bulk-select.css';
var BulkSelect = function (_a) {
    var id = _a.id, _b = _a.isDisabled, isDisabled = _b === void 0 ? false : _b, _c = _a.items, items = _c === void 0 ? [] : _c, _d = _a.onSelect, onSelect = _d === void 0 ? function () { return undefined; } : _d, _e = _a.checked, checked = _e === void 0 ? false : _e, toggleProps = _a.toggleProps, count = _a.count, _f = _a.className, className = _f === void 0 ? '' : _f, ouiaId = _a.ouiaId, _g = _a.ouiaSafe, ouiaSafe = _g === void 0 ? true : _g, props = __rest(_a, ["id", "isDisabled", "items", "onSelect", "checked", "toggleProps", "count", "className", "ouiaId", "ouiaSafe"]);
    var _h = useState(false), isOpen = _h[0], setIsOpen = _h[1];
    var hasError = useRef(false).current;
    var ouiaStateId = useRef(getDefaultOUIAId('RHI/BulkSelect')).current;
    var onToggle = function (isOpen) { return setIsOpen(isOpen); };
    var ouiaFinalId = ouiaId !== undefined ? ouiaId : ouiaStateId;
    return (React.createElement(Fragment, null, items && items.length > 0 ? (React.createElement(Dropdown, __assign({ onSelect: function () { return onToggle(false); } }, props, { className: classnames(className, 'ins-c-bulk-select'), ouiaId: ouiaFinalId, ouiaSafe: ouiaSafe, toggle: React.createElement(DropdownToggle, __assign({}, toggleProps, { isDisabled: isDisabled, ouiaId: ouiaFinalId, splitButtonItems: [
                React.createElement(Fragment, { key: "split-checkbox" }, hasError ? (React.createElement(DropdownToggleCheckbox, { id: id ? "".concat(id, "-toggle-checkbox") : 'toggle-checkbox', "aria-label": "Select all", onChange: onSelect, checked: checked, ouiaId: ouiaFinalId })) : (React.createElement(DropdownToggleCheckbox, { id: id ? "".concat(id, "-toggle-checkbox") : 'toggle-checkbox', "aria-label": "Select all", onChange: onSelect, isChecked: checked, ouiaId: ouiaFinalId }, count ? "".concat(count, " selected") : ''))),
            ], onToggle: onToggle })), isOpen: isOpen, dropdownItems: __spreadArray(__spreadArray([], (count !== undefined && count > 0
            ? [
                React.createElement(DropdownItem, { key: "count", isDisabled: true, className: classnames({
                        'ins-c-bulk-select__selected': !hasError,
                    }) },
                    count,
                    " Selected"),
            ]
            : []), true), items.map(function (oneItem, key) { return (React.createElement(DropdownItem, __assign({ component: "button", key: oneItem.key || key, ouiaId: "".concat(ouiaFinalId, "-").concat(oneItem.key || key), onClick: function (event) { return oneItem.onClick && oneItem.onClick(event, oneItem, key); } }, oneItem === null || oneItem === void 0 ? void 0 : oneItem.props), oneItem.title)); }), true) }))) : (React.createElement(Checkbox, __assign({}, props, { "aria-label": "Select all", className: classnames(className, 'ins-c-bulk-select'), id: "".concat(id, "-checkbox"), isChecked: checked, onChange: onSelect })))));
};
export default BulkSelect;
//# sourceMappingURL=BulkSelect.js.map