var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a;
import React, { Component } from 'react';
import { Dropdown, DropdownItem, DropdownToggle, SplitItem, Split, ToolbarItem, ToolbarGroup, ToolbarToggleGroup } from '@patternfly/react-core';
import { FilterIcon } from '@patternfly/react-icons';
import globalBreakpointMd from '@patternfly/react-tokens/dist/js/global_breakpoint_md';
import Text from './TextFilter';
import { conditionalFilterType, typeMapper } from './conditionalFilterConstants';
import PropTypes from 'prop-types';
import './conditional-filter.css';
import { Fragment } from 'react';
import classNames from 'classnames';
var ConditionalFilter = (function (_super) {
    __extends(ConditionalFilter, _super);
    function ConditionalFilter(props) {
        var _this = this;
        if (!props.useMobileLayout) {
            console.warn("The prop \"useMobileLayout\" is set to false. You are using an outdated mobile layout of conditional filter.\n            Please switch to new layout by adding \"useMobileLayout={true}\" prop to the PrimaryToolbar or ConditionalFilter directly.\n            The new mobile layout will become the default in next minor release.");
        }
        _this = _super.call(this, props) || this;
        _this.dropdownToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        _this.onChange = function (_e, value) {
            _this.setState({
                stateValue: value,
            });
        };
        _this.getWrapper = function () {
            return _this.props.useMobileLayout && _this.state.isMobile
                ? function (props) { return React.createElement(ToolbarToggleGroup, __assign({}, props, { breakpoint: "md", toggleIcon: React.createElement(FilterIcon, null) })); }
                : Fragment;
        };
        _this.updateFilterViewport = function (width) { return width <= _this.breakpointConstant; };
        _this.breakpointConstant = parseInt(globalBreakpointMd.value.replace('px', ''));
        _this.state = {
            isOpen: false,
            stateValue: undefined,
            isMobile: _this.updateFilterViewport(window.innerWidth),
        };
        return _this;
    }
    ConditionalFilter.prototype.componentDidMount = function () {
        var _this = this;
        this.resizeListener = window.addEventListener('resize', function (event) {
            _this.setState(function (prev) { return (__assign(__assign({}, prev), { isMobile: _this.updateFilterViewport(event.target.innerWidth) })); });
        });
    };
    ConditionalFilter.prototype.componentWillUnmount = function () {
        if (this.resizeListener) {
            window.removeEventListener(this.resizeListener);
        }
    };
    ConditionalFilter.prototype.render = function () {
        var _this = this;
        var _a = this.props, items = _a.items, value = _a.value, onChange = _a.onChange, placeholder = _a.placeholder, hideLabel = _a.hideLabel, isDisabled = _a.isDisabled, useMobileLayout = _a.useMobileLayout, props = __rest(_a, ["items", "value", "onChange", "placeholder", "hideLabel", "isDisabled", "useMobileLayout"]);
        var _b = this.state, isOpen = _b.isOpen, stateValue = _b.stateValue, isMobile = _b.isMobile;
        var currentValue = onChange ? value : stateValue;
        var activeItem = items && items.length && (items.find(function (item, key) { return item.value === currentValue || key === currentValue; }) || items[0]);
        var onChangeCallback = onChange || this.onChange;
        var ActiveComponent = activeItem && (typeMapper[activeItem.type] || typeMapper.text);
        var capitalize = function (string) { return string[0].toUpperCase() + string.substring(1); };
        var shouldRenderNewLayout = useMobileLayout && isMobile;
        var Wrapper = this.getWrapper();
        return (React.createElement(Wrapper, null,
            useMobileLayout && isMobile && (React.createElement(ToolbarGroup, { className: "ins-c-conditional-filter mobile" }, items.map(function (activeItem, key) {
                var ActiveComponent = activeItem && (typeMapper[activeItem.type] || typeMapper.text);
                return (React.createElement(ToolbarItem, { key: key },
                    React.createElement(ActiveComponent, __assign({}, (activeItem.type !== conditionalFilterType.custom && {
                        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
                        id: (activeItem.filterValues && activeItem.filterValues.id) || currentValue,
                    }), activeItem.filterValues))));
            }))),
            !shouldRenderNewLayout && (React.createElement(Fragment, null, !items || (items && items.length <= 0) ? (React.createElement("div", { className: classNames('ins-c-conditional-filter', {
                    desktop: useMobileLayout,
                }) },
                React.createElement(Text, __assign({}, props, { value: currentValue, onChange: function (e) { return onChangeCallback(e, e.target.value); }, placeholder: placeholder, "widget-type": "InsightsInput" })))) : (React.createElement(Split, { className: classNames('ins-c-conditional-filter', {
                    desktop: useMobileLayout,
                }) },
                items.length > 1 && (React.createElement(SplitItem, null,
                    React.createElement(Dropdown, { className: "ins-c-conditional-filter__group", onSelect: function () { return _this.dropdownToggle(false); }, isOpen: isOpen, ouiaId: "ConditionalFilter", toggle: React.createElement(DropdownToggle, { "aria-label": "Conditional filter", onToggle: this.dropdownToggle, isDisabled: isDisabled, className: hideLabel ? 'ins-c-conditional-filter__no-label' : '', ouiaId: "ConditionalFilter" },
                            React.createElement(FilterIcon, { size: "sm" }),
                            !hideLabel && (React.createElement("span", { className: "ins-c-conditional-filter__value-selector" }, activeItem && capitalize(activeItem.label)))), dropdownItems: items.map(function (item, key) { return (React.createElement(DropdownItem, { key: item.id ? "".concat(item.id, "-dropdown") : key, component: "button", ouiaId: item.label, onClick: function (e) { return onChangeCallback(e, item.value || key, item); }, isHovered: activeItem.label === item.label }, capitalize(item.label))); }) }))),
                ActiveComponent && (React.createElement(SplitItem, { isFilled: true },
                    React.createElement(ActiveComponent, __assign({}, (activeItem.type !== conditionalFilterType.custom && {
                        placeholder: placeholder || activeItem.placeholder || "Filter by ".concat(activeItem.label),
                        id: (activeItem.filterValues && activeItem.filterValues.id) || currentValue,
                    }), activeItem.filterValues))))))))));
    };
    return ConditionalFilter;
}(Component));
var TextInputProps = {
    value: PropTypes.string,
    placeholder: PropTypes.string,
    onChange: PropTypes.func,
};
ConditionalFilter.propTypes = __assign(__assign({ hideLabel: PropTypes.bool, items: PropTypes.arrayOf(PropTypes.shape({
        id: PropTypes.string,
        label: PropTypes.node,
        value: PropTypes.string,
        type: PropTypes.oneOf(['text', 'checkbox', 'radio', 'custom', 'group']),
        filterValues: PropTypes.oneOfType([
            PropTypes.shape(TextInputProps),
            PropTypes.shape(__assign(__assign({}, TextInputProps), { value: PropTypes.oneOfType([
                    PropTypes.string,
                    PropTypes.arrayOf(PropTypes.oneOfType([
                        PropTypes.string,
                        PropTypes.shape({
                            label: PropTypes.node,
                            value: PropTypes.string,
                        }),
                    ])),
                    PropTypes.shape((_a = {},
                        _a[PropTypes.string] = PropTypes.any,
                        _a)),
                ]), items: PropTypes.arrayOf(PropTypes.shape({
                    label: PropTypes.node,
                    value: PropTypes.string,
                })) })),
        ]),
    })) }, TextInputProps), { id: PropTypes.string, isDisabled: PropTypes.bool, useMobileLayout: PropTypes.bool });
ConditionalFilter.defaultProps = {
    value: '',
    items: [],
    hideLabel: false,
    isDisabled: false,
    id: 'default-input',
    useMobileLayout: false,
};
export default ConditionalFilter;
//# sourceMappingURL=ConditionalFilter.js.map