var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import groupTypes from './groupType';
export var isChecked = function (groupValue, itemValue, id, tagValue, stateSelected, propSelected) {
    var _a, _b, _c, _d, _e, _f, _g, _h;
    var selected = __assign(__assign({}, propSelected), stateSelected);
    if (typeof selected[groupValue] === 'undefined') {
        return false;
    }
    if (selected[groupValue][itemValue] instanceof Object) {
        if (selected[groupValue][itemValue].isSelected) {
            if ((_b = (_a = selected[groupValue][itemValue]) === null || _a === void 0 ? void 0 : _a.item) === null || _b === void 0 ? void 0 : _b.id) {
                return id === ((_d = (_c = selected[groupValue][itemValue]) === null || _c === void 0 ? void 0 : _c.item) === null || _d === void 0 ? void 0 : _d.id);
            }
            else if ((_f = (_e = selected[groupValue][itemValue]) === null || _e === void 0 ? void 0 : _e.item) === null || _f === void 0 ? void 0 : _f.tagValue) {
                return tagValue === ((_h = (_g = selected[groupValue][itemValue]) === null || _g === void 0 ? void 0 : _g.item) === null || _h === void 0 ? void 0 : _h.tagValue);
            }
        }
        return selected[groupValue][itemValue].isSelected;
    }
    return Boolean(selected[groupValue][itemValue]);
};
export var getMenuItems = function (items, onChange, calculateSelected, groupType, groupValue, groupLabel, groupId, group) {
    if (groupValue === void 0) { groupValue = ''; }
    var result = (items === null || items === void 0 ? void 0 : items.map(function (item, index) { return (__assign(__assign({}, item), { className: "".concat((item === null || item === void 0 ? void 0 : item.className) || 'pf-u-pl-sm'), key: item.id || item.value || index, value: String(item.value || item.id || index), onClick: function (event, treeViewItem, checked) {
            var _a;
            var params = [
                event,
                calculateSelected(groupType || item.type, groupValue, (groupType || item.type) === groupTypes.treeView ? treeViewItem : item.value, checked),
                __assign({ value: groupValue, label: groupLabel || item.label, id: groupId || item.id, type: groupType || item.type, items: items }, (group || item)),
                item,
                groupValue,
                item.value,
            ];
            onChange.apply(void 0, params);
            (_a = item === null || item === void 0 ? void 0 : item.onClick) === null || _a === void 0 ? void 0 : _a.call.apply(_a, __spreadArray([item], params, false));
        } })); })) || [];
    return result.filter(function (_a) {
        var noFilter = _a.noFilter;
        return !noFilter;
    });
};
export var convertTreeItem = function (item) {
    item.id = item.id || item.value;
    item.name = item.label || item.name;
    item.value = item.id;
    item.label = item.name;
    return item.children
        ? __assign(__assign({}, item), { children: item.children.map(function (child) { return convertTreeItem(child); }) }) : item;
};
export var getGroupMenuItems = function (groups, onChange, calculateSelected) {
    var result = groups.map(function (_a) {
        var value = _a.value, label = _a.label, groupSelectable = _a.groupSelectable, id = _a.id, type = _a.type, items = _a.items, group = __rest(_a, ["value", "label", "groupSelectable", "id", "type", "items"]);
        var converted = type === groupTypes.treeView ? items.map(function (item) { return convertTreeItem(item); }) : items;
        return {
            label: label,
            value: value,
            type: type,
            groupSelectable: groupSelectable,
            items: getMenuItems(__spreadArray(__spreadArray([], (groupSelectable
                ? [
                    __assign({ value: value, label: label, id: id, type: type, className: 'pf-u-pl-xs' }, group),
                ]
                : []), true), converted, true), onChange, calculateSelected, type, value, label, id, group),
        };
    });
    return result.filter(function (_a) {
        var noFilter = _a.noFilter, _b = _a.items, items = _b === void 0 ? [] : _b;
        return !noFilter || items.length > 0;
    });
};
export var calculateSelected = function (selectedTags) { return function (type, groupKey, value, checked) {
    var activeGroup = selectedTags === null || selectedTags === void 0 ? void 0 : selectedTags[groupKey];
    var children = type === groupTypes.treeView &&
        [value].reduce(function iter(r, a) {
            if (Array.isArray(a.children)) {
                return a.children.reduce(iter, r);
            }
            r.push(a);
            return r;
        }, []);
    var itemKeys = type === groupTypes.treeView ? children.map(function (item) { return item.id; }) : [value];
    if (activeGroup) {
        var result_1 = selectedTags;
        itemKeys.map(function (itemKey) {
            var _a, _b, _c, _d;
            var activeGroup = result_1[groupKey];
            if (type !== groupTypes.radio && (activeGroup[itemKey] instanceof Object ? activeGroup[itemKey].isSelected : Boolean(activeGroup[itemKey]))) {
                result_1 = __assign(__assign({}, result_1), (_a = {}, _a[groupKey] = __assign(__assign({}, (activeGroup || {})), (_b = {}, _b[itemKey] = type === groupTypes.treeView && checked, _b)), _a));
            }
            else {
                result_1 = __assign(__assign({}, result_1), (_c = {}, _c[groupKey] = __assign(__assign({}, (type !== groupTypes.radio ? activeGroup || {} : {})), (_d = {}, _d[itemKey] = true, _d)), _c));
            }
        });
        return result_1;
    }
    return itemKeys.reduce(function (acc, curr) {
        var _a, _b;
        return (__assign(__assign({}, acc), (_a = {}, _a[groupKey] = __assign(__assign({}, acc === null || acc === void 0 ? void 0 : acc[groupKey]), (_b = {}, _b[curr] = true, _b)), _a)));
    }, selectedTags);
}; };
var areAllChildrenChecked = function (dataItem, groupKey, stateSelected, selected) {
    return dataItem.children
        ? dataItem.children.every(function (child) { return areAllChildrenChecked(child, groupKey, stateSelected, selected); })
        : isChecked(groupKey, dataItem.id, undefined, undefined, stateSelected, selected);
};
var areSomeChildrenChecked = function (dataItem, groupKey, stateSelected, selected) {
    return dataItem.children
        ? dataItem.children.some(function (child) { return areSomeChildrenChecked(child, groupKey, stateSelected, selected); })
        : isChecked(groupKey, dataItem.id, undefined, undefined, stateSelected, selected);
};
export var mapTree = function (item, groupKey, stateSelected, selected) {
    var hasCheck = areAllChildrenChecked(item, groupKey, stateSelected, selected);
    item.checkProps = { checked: false };
    if (hasCheck) {
        item.checkProps.checked = true;
    }
    else {
        var hasPartialCheck = areSomeChildrenChecked(item, groupKey, stateSelected, selected);
        if (hasPartialCheck) {
            item.checkProps = { checked: null };
        }
    }
    if (item.children) {
        return __assign(__assign({}, item), { children: item.children.map(function (child) { return mapTree(child, groupKey, stateSelected, selected); }) });
    }
    return item;
};
export var onTreeCheck = function (e, treeViewItem, tree) { var _a; return tree[0].onClick(e, treeViewItem, (_a = e === null || e === void 0 ? void 0 : e.target) === null || _a === void 0 ? void 0 : _a.checked); };
//# sourceMappingURL=groupFilterConstants.js.map