export var seconds = 1000;
export var minutes = seconds * 60;
export var hours = minutes * 60;
export var days = hours * 24;
export var calculateTooltip = function (culled, warning, currDate) {
    var culledDate = new Date(culled);
    var warningDate = new Date(warning);
    var diffTime = new Date(currDate).valueOf() - warningDate.valueOf();
    var removeIn = Math.ceil((culledDate.valueOf() - new Date(currDate).valueOf()) / days);
    var msg = "System scheduled for inventory removal in ".concat(removeIn, " days");
    if (diffTime >= 0) {
        return {
            isError: true,
            msg: msg,
        };
    }
    return {
        isWarn: true,
        msg: msg,
    };
};
//# sourceMappingURL=utils.js.map