var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { Dropdown, DropdownItem, DropdownToggle, Tooltip } from '@patternfly/react-core';
import React, { useState } from 'react';
import { ExportIcon } from '@patternfly/react-icons';
var DownloadButton = function (_a) {
    var _b = _a.extraItems, extraItems = _b === void 0 ? [] : _b, _c = _a.onSelect, onSelect = _c === void 0 ? function () { return undefined; } : _c, isDisabled = _a.isDisabled, tooltipText = _a.tooltipText, props = __rest(_a, ["extraItems", "onSelect", "isDisabled", "tooltipText"]);
    var _d = useState(false), isOpen = _d[0], setIsOpen = _d[1];
    var onToggle = function (isOpen) { return setIsOpen(isOpen); };
    var internalOnSelect = function () { return setIsOpen(function (prev) { return !prev; }); };
    var conditionallyTooltip = function (children) {
        return React.createElement(React.Fragment, null, tooltipText ? React.createElement(Tooltip, { content: tooltipText }, children) : children);
    };
    return (React.createElement(React.Fragment, null, conditionallyTooltip(React.createElement(Dropdown, __assign({}, props, { isPlain: true, onSelect: internalOnSelect, toggle: React.createElement(DropdownToggle, { toggleIndicator: null, onToggle: onToggle, isDisabled: isDisabled, ouiaId: "Export" },
            React.createElement(ExportIcon, { size: "sm" })), isOpen: isOpen, ouiaId: "Export", dropdownItems: __spreadArray([
            React.createElement(DropdownItem, { key: "download-csv", ouiaId: "DownloadCSV", component: "button", onClick: function (event) { return onSelect(event, 'csv'); }, isDisabled: isDisabled }, "Export to CSV"),
            React.createElement(DropdownItem, { key: "download-json", ouiaId: "DownloadJSON", component: "button", onClick: function (event) { return onSelect(event, 'json'); }, isDisabled: isDisabled }, "Export to JSON")
        ], extraItems, true) })))));
};
export default DownloadButton;
//# sourceMappingURL=DownloadButton.js.map