var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import React from 'react';
import { ExclamationCircleIcon } from '@patternfly/react-icons/';
import DefaultErrorMessage from './DefaultErrorMessage';
import { Title, EmptyState, EmptyStateVariant, EmptyStateIcon, EmptyStateBody, Button, Stack, StackItem, } from '@patternfly/react-core';
import './error-state.css';
var ErrorState = function (_a) {
    var _b = _a.errorTitle, errorTitle = _b === void 0 ? 'Something went wrong' : _b, errorDescription = _a.errorDescription, props = __rest(_a, ["errorTitle", "errorDescription"]);
    return (React.createElement(EmptyState, __assign({ variant: EmptyStateVariant.large }, props, { className: "ins-c-error-state" }),
        React.createElement(EmptyStateIcon, { icon: ExclamationCircleIcon }),
        React.createElement(Title, { headingLevel: "h4", size: "lg" }, errorTitle),
        React.createElement(EmptyStateBody, null,
            React.createElement(Stack, null,
                !errorDescription && React.createElement(StackItem, null, "There was a problem processing the request. Please try again."),
                React.createElement(StackItem, null, errorDescription || React.createElement(DefaultErrorMessage, null)))),
        document.referrer ? (React.createElement(Button, { variant: "primary", onClick: function () { return history.back(); } }, "Return to last page")) : (React.createElement(Button, { variant: "primary", component: "a", href: ".", target: "_blank", rel: "noopener noreferrer" }, "Go to home page"))));
};
export default ErrorState;
//# sourceMappingURL=ErrorState.js.map