var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import React, { Component } from 'react';
import { Dropdown, DropdownToggle, Level } from '@patternfly/react-core';
import { getDefaultOUIAId } from '@patternfly/react-core/';
import PropTypes from 'prop-types';
import FilterInput from './FilterInput.js';
import './filter-dropdown.css';
var FilterDropdown = (function (_super) {
    __extends(FilterDropdown, _super);
    function FilterDropdown() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            isOpen: false,
            ouiaStateId: getDefaultOUIAId('RHI/FilterDropdown'),
        };
        _this.addRemoveFilters = function (selectedValue, filterName, type, isChecked) {
            switch (type) {
                case 'checkbox':
                    isChecked ? _this.props.addFilter(filterName, selectedValue, type) : _this.props.removeFilter(filterName, selectedValue);
                    break;
                case 'radio':
                    _this.props.addFilter(filterName, selectedValue, type);
                    break;
            }
        };
        _this.onToggle = function (isOpen) {
            _this.setState({
                isOpen: isOpen,
            });
        };
        return _this;
    }
    FilterDropdown.prototype.render = function () {
        var _this = this;
        var _a = this.props, hideCategories = _a.hideCategories, filters = _a.filters, filterCategories = _a.filterCategories, label = _a.label, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
        var _b = this.state, isOpen = _b.isOpen, ouiaStateId = _b.ouiaStateId;
        var ouiaFinalId = ouiaId !== undefined ? ouiaId : ouiaStateId;
        return (React.createElement(Dropdown, { className: "ins-c-filter__dropdown", onSelect: this.onSelect, toggle: React.createElement(DropdownToggle, { ouiaId: ouiaFinalId, ouiaSafe: ouiaSafe, onToggle: this.onToggle }, label), isOpen: isOpen, ouiaId: ouiaFinalId, ouiaSafe: ouiaSafe },
            React.createElement("div", { className: "pf-c-dropdown__menu-item" }, filterCategories.map(function (data, index) {
                return !hideCategories.includes(data.urlParam) && (React.createElement(Level, { key: "".concat(data.urlParam).concat(index) },
                    data.title,
                    data.values.map(function (item, key) { return (React.createElement(FilterInput, { key: "check".concat(index).concat(key), "aria-label": item.label, id: "".concat(data.urlParam).concat(key), label: item.label, addRemoveFilters: _this.addRemoveFilters, param: data.urlParam, type: data.type, value: item.value, filters: filters })); }),
                    index !== filterCategories.length - 1 && React.createElement("br", null)));
            }))));
    };
    return FilterDropdown;
}(Component));
FilterDropdown.propTypes = {
    addFilter: PropTypes.func,
    removeFilter: PropTypes.func,
    hideCategories: PropTypes.array,
    filters: PropTypes.object,
    filterCategories: PropTypes.arrayOf(PropTypes.shape({
        title: PropTypes.string,
        type: PropTypes.type,
        urlParam: PropTypes.string,
        values: PropTypes.arrayOf(PropTypes.shape({
            label: PropTypes.node,
            value: PropTypes.any,
        })),
    })),
    label: PropTypes.oneOfType([PropTypes.string, PropTypes.node]),
    ouiaId: PropTypes.string,
    ouiaSafe: PropTypes.bool,
};
FilterDropdown.defaultProps = {
    addFilter: Function.prototype,
    removeFilter: Function.prototype,
    hideCategories: [],
    filters: {},
    label: 'Filters',
    ouiaSafe: true,
};
export default FilterDropdown;
//# sourceMappingURL=FilterDropdown.js.map