var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import './labels.css';
import { AngleDoubleDownIcon } from '@patternfly/react-icons';
import { AngleDoubleUpIcon } from '@patternfly/react-icons';
import CriticalIcon from './CriticalIcon';
import { EqualsIcon } from '@patternfly/react-icons';
import { Label } from '@patternfly/react-core';
import React from 'react';
import classNames from 'classnames';
var VALUE_TO_STATE = {
    1: { icon: React.createElement(AngleDoubleDownIcon, null), text: 'Low' },
    2: { icon: React.createElement(EqualsIcon, null), text: 'Moderate' },
    3: { icon: React.createElement(AngleDoubleUpIcon, null), text: 'Important' },
    4: { icon: React.createElement(CriticalIcon, null), text: 'Critical' },
};
var InsightsLabel = function (_a) {
    var _b = _a.value, value = _b === void 0 ? 1 : _b, text = _a.text, hideIcon = _a.hideIcon, className = _a.className, rest = _a.rest, props = __rest(_a, ["value", "text", "hideIcon", "className", "rest"]);
    return (React.createElement(Label, __assign({}, rest, props, { className: classNames(className, "ins-c-label-".concat(value)), icon: !hideIcon && VALUE_TO_STATE[value].icon }), text || VALUE_TO_STATE[value].text));
};
export default InsightsLabel;
//# sourceMappingURL=InsightsLabel.js.map