import React from 'react';
import propTypes from 'prop-types';
import { EmptyState, EmptyStateIcon, EmptyStateBody, Title, Button } from '@patternfly/react-core';
import { DisconnectedIcon } from '@patternfly/react-icons';
var NotConnected = function (_a) {
    var titleText = _a.titleText, bodyText = _a.bodyText, buttonText = _a.buttonText;
    return (React.createElement(EmptyState, null,
        React.createElement(EmptyStateIcon, { icon: DisconnectedIcon }),
        React.createElement(Title, { headingLevel: "h5", size: "lg" }, titleText),
        React.createElement(EmptyStateBody, null, bodyText),
        React.createElement(Button, { variant: "primary", component: "a", href: "http://access.redhat.com/products/cloud_management_services_for_rhel#getstarted", target: "_blank", rel: "noopener noreferrer", className: "pf-u-mt-lg" }, buttonText)));
};
NotConnected.propTypes = {
    titleText: propTypes.node,
    bodyText: propTypes.node,
    buttonText: propTypes.node,
};
NotConnected.defaultProps = {
    titleText: 'This system isn’t connected to Insights yet',
    bodyText: 'To get started, activate the Insights client for this system.',
    buttonText: 'Learn how to activate the Insights client',
};
export default NotConnected;
//# sourceMappingURL=NotConnected.js.map