var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var _a;
import { Toolbar, ToolbarContent, ToolbarGroup, ToolbarItem, Pagination, Button, ToolbarExpandIconWrapper } from '@patternfly/react-core';
import { AngleDownIcon, AngleRightIcon } from '@patternfly/react-icons';
import React, { Component } from 'react';
import Actions from './Actions';
import { BulkSelect } from '../BulkSelect';
import { ConditionalFilter } from '../ConditionalFilter';
import { DownloadButton } from '../DownloadButton';
import { FilterChips } from '../FilterChips';
import PropTypes from 'prop-types';
import SortBy from './SortBy';
import { SortByDirection } from '@patternfly/react-table';
import './primary-toolbar.css';
var PrimaryToolbar = (function (_super) {
    __extends(PrimaryToolbar, _super);
    function PrimaryToolbar() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PrimaryToolbar.prototype.render = function () {
        var _a = this.props, id = _a.id, className = _a.className, toggleIsExpanded = _a.toggleIsExpanded, bulkSelect = _a.bulkSelect, filterConfig = _a.filterConfig, dedicatedAction = _a.dedicatedAction, actionsConfig = _a.actionsConfig, sortByConfig = _a.sortByConfig, pagination = _a.pagination, activeFiltersConfig = _a.activeFiltersConfig, children = _a.children, exportConfig = _a.exportConfig, expandAll = _a.expandAll, useMobileLayout = _a.useMobileLayout, props = __rest(_a, ["id", "className", "toggleIsExpanded", "bulkSelect", "filterConfig", "dedicatedAction", "actionsConfig", "sortByConfig", "pagination", "activeFiltersConfig", "children", "exportConfig", "expandAll", "useMobileLayout"]);
        var overflowActions = __spreadArray([], (sortByConfig
            ? [
                {
                    label: 'Sort order ASC',
                    props: { isDisabled: sortByConfig.direction === SortByDirection.asc },
                    onClick: function (e) { return sortByConfig.onSortChange && sortByConfig.onSortChange(e, SortByDirection.asc); },
                },
                {
                    label: 'Sort order DESC',
                    props: { isDisabled: sortByConfig.direction === SortByDirection.desc },
                    onClick: function (e) { return sortByConfig.onSortChange && sortByConfig.onSortChange(e, SortByDirection.desc); },
                },
            ]
            : []), true);
        return (React.createElement(Toolbar, __assign({}, props, { className: "".concat(className || '', " ins-c-primary-toolbar"), toggleIsExpanded: toggleIsExpanded, id: id || 'ins-primary-data-toolbar', ouiaId: "PrimaryToolbar" }),
            React.createElement(ToolbarContent, null,
                (expandAll || bulkSelect || filterConfig || dedicatedAction) && (React.createElement(ToolbarGroup, { className: "ins-c-primary-toolbar__group-filter pf-m-spacer-md pf-m-space-items-lg", variant: "filter-group" },
                    expandAll && (React.createElement(ToolbarItem, null, React.isValidElement(expandAll) ? (expandAll) : (React.createElement(Button, __assign({ variant: "plain", "aria-label": "".concat(expandAll.isAllExpanded ? 'Collapse' : 'Expand', " all"), onClick: function (e) { return expandAll.onClick(e, !expandAll.isAllExpanded); }, ouiaId: "ExpandCollapseAll", isDisabled: expandAll.isDisabled }, expandAll.buttonProps),
                        React.createElement(ToolbarExpandIconWrapper, null, expandAll.isAllExpanded ? React.createElement(AngleDownIcon, null) : React.createElement(AngleRightIcon, null)))))),
                    bulkSelect && (React.createElement(ToolbarItem, null, React.isValidElement(bulkSelect) ? bulkSelect : React.createElement(BulkSelect, __assign({ ouiaId: "BulkSelect" }, bulkSelect)))),
                    filterConfig && (React.createElement(ToolbarItem, { className: "ins-c-primary-toolbar__filter" }, React.isValidElement(filterConfig) ? filterConfig : React.createElement(ConditionalFilter, __assign({ useMobileLayout: useMobileLayout }, filterConfig)))),
                    dedicatedAction && React.createElement(ToolbarItem, null, dedicatedAction))),
                React.isValidElement(actionsConfig)
                    ? actionsConfig
                    : ((actionsConfig && actionsConfig.actions && actionsConfig.actions.length > 0) || sortByConfig || exportConfig) && (React.createElement(Actions, __assign({}, (actionsConfig || {}), { exportConfig: exportConfig, overflowActions: overflowActions }))),
                sortByConfig && (React.createElement(ToolbarItem, { className: "ins-c-primary-toolbar__sort-by" }, React.isValidElement(sortByConfig) ? sortByConfig : React.createElement(SortBy, __assign({}, sortByConfig)))),
                children,
                pagination && (React.createElement(ToolbarItem, { className: "ins-c-primary-toolbar__pagination" }, React.isValidElement(pagination) ? pagination : React.createElement(Pagination, __assign({ isCompact: true, ouiaId: "CompactPagination" }, pagination))))),
            activeFiltersConfig && React.isValidElement(activeFiltersConfig) ? (React.createElement(ToolbarContent, null,
                React.createElement(ToolbarItem, null, activeFiltersConfig))) : (activeFiltersConfig !== undefined &&
                (activeFiltersConfig.filters.length > 0 || activeFiltersConfig.showDeleteButton === true) && (React.createElement(ToolbarContent, null,
                React.createElement(ToolbarItem, null,
                    React.createElement(FilterChips, __assign({}, activeFiltersConfig))))))));
    };
    return PrimaryToolbar;
}(Component));
PrimaryToolbar.propTypes = {
    id: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),
    className: PropTypes.string,
    toggleIsExpanded: PropTypes.func,
    bulkSelect: PropTypes.shape(BulkSelect.propTypes),
    filterConfig: PropTypes.shape(ConditionalFilter.propTypes),
    dedicatedAction: PropTypes.node,
    pagination: PropTypes.shape(Pagination.propTypes),
    sortByConfig: PropTypes.shape(SortBy.propTypes),
    exportConfig: PropTypes.shape(DownloadButton.propTypes),
    activeFiltersConfig: PropTypes.shape(FilterChips.propTypes),
    children: PropTypes.node,
    actionsConfig: PropTypes.shape({
        actions: Actions.propTypes.actions,
        dropdownProps: Actions.propTypes.dropdownProps,
        onSelect: Actions.propTypes.onSelect,
    }),
    expandAll: PropTypes.oneOfType([
        PropTypes.node,
        PropTypes.shape({
            onClick: PropTypes.func,
            isAllExpanded: PropTypes.bool,
            isDisabled: PropTypes.bool,
            buttonProps: PropTypes.shape((_a = {},
                _a[PropTypes.string] = PropTypes.object,
                _a)),
        }),
    ]),
    useMobileLayout: PropTypes.bool,
};
export default PrimaryToolbar;
//# sourceMappingURL=PrimaryToolbar.js.map