var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _a, _b;
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import './tagModal.css';
import { Modal, Button, Tabs, Tab, TabTitleText } from '@patternfly/react-core';
import classNames from 'classnames';
import TableWithFilter from './TableWithFilter';
var calculateChecked = function (rows, selected) {
    if (rows === void 0) { rows = []; }
    return rows.every(function (_a) {
        var id = _a.id;
        return selected && selected.find(function (_a) {
            var selectedId = _a.id;
            return selectedId === id;
        });
    })
        ? rows.length > 0
        : rows.some(function (_a) {
            var id = _a.id;
            return selected && selected.find(function (_a) {
                var selectedId = _a.id;
                return selectedId === id;
            });
        }) && null;
};
var unique = function (arr) { return arr.filter(function (_a, index, arr) {
    var id = _a.id;
    return arr.findIndex(function (_a) {
        var currId = _a.id;
        return currId === id;
    }) === index;
}); };
var TagModal = (function (_super) {
    __extends(TagModal, _super);
    function TagModal() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.state = {
            selectedTab: 0,
        };
        _this.handleTabClick = function (_event, tabIndex) {
            _this.setState({ activeTabKey: tabIndex });
        };
        _this.renderTable = function (rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData, bulkSelect) { return (React.createElement(TableWithFilter, __assign({}, _this.props, { rows: rows, pagination: pagination, loaded: loaded, calculateChecked: calculateChecked, unique: unique, filters: filters, title: _this.props.title, systemName: _this.props.systemName, columns: columns, onSelect: onSelect, onUpdateData: onUpdateData, selected: selected, bulkSelect: bulkSelect }), _this.props.children)); };
        return _this;
    }
    TagModal.prototype.render = function () {
        var _this = this;
        var _a = this.props, className = _a.className, title = _a.title, systemName = _a.systemName, toggleModal = _a.toggleModal, isOpen = _a.isOpen, rows = _a.rows, columns = _a.columns, children = _a.children, pagination = _a.pagination, loaded = _a.loaded, filters = _a.filters, onApply = _a.onApply, tabNames = _a.tabNames, onSelect = _a.onSelect, onUpdateData = _a.onUpdateData, selected = _a.selected, tableProps = _a.tableProps, bulkSelect = _a.bulkSelect, props = __rest(_a, ["className", "title", "systemName", "toggleModal", "isOpen", "rows", "columns", "children", "pagination", "loaded", "filters", "onApply", "tabNames", "onSelect", "onUpdateData", "selected", "tableProps", "bulkSelect"]);
        var isTabbed = Array.isArray(tabNames);
        return (React.createElement(Modal, __assign({}, props, { className: classNames('ins-c-tag-modal', className), isOpen: isOpen, title: title || "Tags for ".concat(systemName), onClose: function (e) { return toggleModal(e, false); }, variant: "medium" }, (onApply && {
            actions: [
                React.createElement(Button, { key: "confirm", variant: "primary", isDisabled: isTabbed ? Object.values(selected || {}).every(function (values) { return !values || (values === null || values === void 0 ? void 0 : values.length) === 0; }) : !selected || (selected === null || selected === void 0 ? void 0 : selected.length) === 0, onClick: function (e) {
                        onApply();
                        toggleModal(e, true);
                    } },
                    "Apply ",
                    isTabbed ? 'selected' : 'tags'),
                React.createElement(Button, { key: "cancel", variant: "link", onClick: function (e) { return toggleModal(e, false); } }, "Cancel"),
            ],
        })), isTabbed ? (React.createElement(Tabs, { activeKey: this.state.activeTabKey, onSelect: this.handleTabClick }, tabNames.map(function (item, key) { return (React.createElement(Tab, { key: key, eventKey: key, title: React.createElement(TabTitleText, null,
                "All ",
                item) }, _this.renderTable(rows === null || rows === void 0 ? void 0 : rows[key], columns === null || columns === void 0 ? void 0 : columns[key], pagination === null || pagination === void 0 ? void 0 : pagination[key], loaded === null || loaded === void 0 ? void 0 : loaded[key], filters === null || filters === void 0 ? void 0 : filters[key], selected === null || selected === void 0 ? void 0 : selected[key], onSelect === null || onSelect === void 0 ? void 0 : onSelect[key], onUpdateData === null || onUpdateData === void 0 ? void 0 : onUpdateData[key], bulkSelect === null || bulkSelect === void 0 ? void 0 : bulkSelect[key]))); }))) : (this.renderTable(rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData, bulkSelect))));
    };
    return TagModal;
}(Component));
TagModal.propTypes = {
    tabNames: PropTypes.arrayOf(PropTypes.string),
    loaded: PropTypes.oneOfType([PropTypes.bool, PropTypes.arrayOf(PropTypes.bool)]),
    title: PropTypes.string,
    systemName: PropTypes.string,
    isOpen: PropTypes.bool,
    toggleModal: PropTypes.func,
    rows: PropTypes.array,
    columns: PropTypes.array,
    className: PropTypes.string,
    tableProps: PropTypes.shape((_a = {},
        _a[PropTypes.string] = PropTypes.any,
        _a)),
    onSelect: PropTypes.oneOfType([PropTypes.func, PropTypes.arrayOf(PropTypes.func)]),
    onUpdateData: PropTypes.oneOfType([PropTypes.func, PropTypes.arrayOf(PropTypes.func)]),
    bulkSelect: PropTypes.oneOfType([PropTypes.any, PropTypes.arrayOf(PropTypes.any)]),
    pagination: PropTypes.oneOfType([TableWithFilter.propTypes.pagination, PropTypes.arrayOf(TableWithFilter.propTypes.pagination)]),
    primaryToolbarProps: PropTypes.shape((_b = {},
        _b[PropTypes.string] = PropTypes.any,
        _b)),
    selected: PropTypes.array,
    children: PropTypes.node,
    filters: PropTypes.any,
    onApply: PropTypes.func,
};
TagModal.defaultProps = {
    loaded: false,
    isOpen: false,
    toggleModal: function () { return undefined; },
    columns: [{ title: 'Name' }, { title: 'Tag source' }],
    onUpdateData: function () { return undefined; },
    rows: [],
    tableProps: {},
    pagination: { count: 10 },
};
export default TagModal;
//# sourceMappingURL=TagModal.js.map