var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import React from 'react';
import { RowWrapper } from '@patternfly/react-table';
import classnames from 'classnames';
var TreeRowWrapper = function (props) {
    var className = props.className;
    var _a = props.row || {}, level = _a.level, isTreeOpen = _a.isTreeOpen, point = _a.point, posinset = _a.posinset;
    return (React.createElement(RowWrapper, __assign({}, props, { "aria-level": level === undefined ? 1 : level + 1, "aria-posinset": posinset, "aria-setsize": point ? point.size : 0, className: classnames({
            className: className,
            'pf-m-expandable': isTreeOpen === true || isTreeOpen === false,
            'pf-m-expanded': isTreeOpen === true,
        }) })));
};
export default TreeRowWrapper;
//# sourceMappingURL=rowWrapper.js.map