'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var DebouncePromise = _interopDefault(require('debounce-promise'));
var awesomeOnlyResolvesLastPromise = require('awesome-only-resolves-last-promise');

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

var DefaultOptions = {
    // One distinct debounced function is created per key and added to an internal cache
    // By default, the key is null, which means that all the calls
    // will share the same debounced function
    key: function () {
        var _args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            _args[_i] = arguments[_i];
        }
        return null;
    },
    // By default, a debounced function will only resolve
    // the last promise it returned
    // Former calls will stay unresolved, so that you don't have
    // to handle concurrency issues in your code
    // Setting this to false means all returned promises will resolve to the last result
    onlyResolvesLast: true,
};
// We create a debouncing function cache, because when wrapping the original function,
// we may actually want to route the function call to different debounced functions depending function paameters
var DebounceCache = /** @class */ (function () {
    function DebounceCache(config) {
        this.config = config;
        this.debounceSingleton = null;
        this.debounceCache = {}; // when key feature is used
    }
    DebounceCache.prototype._createDebouncedFunction = function () {
        var debouncedFunc = DebouncePromise(this.config.func, this.config.wait, this.config.options); // TODO TS
        if (this.config.options.onlyResolvesLast) {
            debouncedFunc = awesomeOnlyResolvesLastPromise.onlyResolvesLast(debouncedFunc);
        }
        return {
            func: debouncedFunc,
        };
    };
    DebounceCache.prototype.getDebouncedFunction = function (args) {
        var _a;
        var key = (_a = this.config.options).key.apply(_a, args);
        if (key === null || typeof key === 'undefined') {
            if (!this.debounceSingleton) {
                this.debounceSingleton = this._createDebouncedFunction();
            }
            return this.debounceSingleton;
        }
        else {
            if (!this.debounceCache[key]) {
                this.debounceCache[key] = this._createDebouncedFunction();
            }
            return this.debounceCache[key];
        }
    };
    return DebounceCache;
}());
function AwesomeDebouncePromise(func, wait, options) {
    var finalOptions = __assign({}, DefaultOptions, options);
    var debounceCache = new DebounceCache({
        func: func,
        wait: wait,
        options: finalOptions,
    });
    var AwesomeDebouncePromiseWrapper = (function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var debouncedFn = debounceCache.getDebouncedFunction(args).func;
        return debouncedFn.apply(void 0, args);
    }); // TODO fix TS
    /*
    AwesomeDebouncePromiseWrapper.cancel = (key?: string) => {
  
    };
    */
    return AwesomeDebouncePromiseWrapper;
}

exports.default = AwesomeDebouncePromise;
//# sourceMappingURL=index.js.map
