"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.feedback = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _thumbsUpIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/thumbs-up-icon"));

var _outlinedThumbsUpIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/outlined-thumbs-up-icon"));

var _thumbsDownIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/thumbs-down-icon"));

var _outlinedThumbsDownIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/outlined-thumbs-down-icon"));

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var feedback = {
  negative: -1,
  neutral: 0,
  positive: 1
}; // ruleId - is id of current rule
// onFeedbackSent(ruleId, vote) is a callback which is called when feedback is changed
// where ruleId is id of the rule, vote is either -1, 0 or 1

exports.feedback = feedback;

var RuleFeedback = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2["default"])(RuleFeedback, _React$Component);

  var _super = _createSuper(RuleFeedback);

  function RuleFeedback() {
    var _this;

    (0, _classCallCheck2["default"])(this, RuleFeedback);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      feedbackSaved: false
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handleFeedbackChange", function (vote) {
      var _this$props = _this.props,
          ruleId = _this$props.ruleId,
          userVote = _this$props.userVote,
          onFeedbackChanged = _this$props.onFeedbackChanged;

      if (userVote === vote) {
        onFeedbackChanged(ruleId, feedback.neutral);
      } else {
        _this.setState({
          feedbackSaved: true
        });

        onFeedbackChanged(ruleId, vote);
      }
    });
    return _this;
  }

  (0, _createClass2["default"])(RuleFeedback, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var userVote = this.props.userVote;
      return /*#__PURE__*/_react["default"].createElement("div", null, /*#__PURE__*/_react["default"].createElement("span", null, "Is this helpful?"), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        className: "ins-c-rule__rule-feedback-like-button",
        variant: "plain",
        "aria-label": "Rule is helpful",
        onClick: function onClick() {
          return _this2.handleFeedbackChange(feedback.positive);
        }
      }, userVote === feedback.positive ? /*#__PURE__*/_react["default"].createElement(_thumbsUpIcon["default"], {
        color: "var(--pf-global--success-color--100)"
      }) : /*#__PURE__*/_react["default"].createElement(_outlinedThumbsUpIcon["default"], null)), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        className: "ins-c-rule__rule-feedback-dislike-button",
        variant: "plain",
        "aria-label": "Rule is not helpful",
        onClick: function onClick() {
          return _this2.handleFeedbackChange(feedback.negative);
        }
      }, userVote === feedback.negative ? /*#__PURE__*/_react["default"].createElement(_thumbsDownIcon["default"], {
        color: "var(--pf-global--primary-color--100)"
      }) : /*#__PURE__*/_react["default"].createElement(_outlinedThumbsDownIcon["default"], null)), this.state.feedbackSaved && 'Thank you for your feedback!');
    }
  }]);
  return RuleFeedback;
}(_react["default"].Component);

;
RuleFeedback.propTypes = {
  ruleId: _propTypes["default"].string.isRequired,
  userVote: _propTypes["default"].oneOf(Object.values(feedback)).isRequired,
  onFeedbackChanged: _propTypes["default"].func.isRequired
};
var _default = RuleFeedback;
exports["default"] = _default;