"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getLabelTextSize = exports.getPieLabelY = exports.getPieLabelX = exports.getBulletLabelY = exports.getBulletLabelX = void 0;
const victory_core_1 = require("victory-core");
const chart_origin_1 = require("./chart-origin");
const ChartTheme_1 = require("../ChartTheme");
// Returns x coordinate for bullet labels
exports.getBulletLabelX = ({ chartWidth, dx = 0, labelPosition }) => labelPosition === 'top' && chartWidth ? Math.round(chartWidth / 2) : dx;
// Returns y coordinate for bullet labels
exports.getBulletLabelY = ({ chartHeight, dy = 0, labelPosition }) => {
    switch (labelPosition) {
        case 'bottom':
            return chartHeight + ChartTheme_1.ChartCommonStyles.label.margin + dy;
        case 'left':
            return chartHeight ? Math.round(chartHeight / 2) + dy : dy;
        default:
            return dy;
    }
};
// Returns x coordinate for pie labels
exports.getPieLabelX = ({ dx = 0, height, labelPosition, legendPosition, padding, width }) => {
    const origin = chart_origin_1.getPieOrigin({ height, padding, width });
    const radius = victory_core_1.Helpers.getRadius({ height, width, padding });
    switch (labelPosition) {
        case 'bottom':
        case 'center':
            return origin.x + dx;
        case 'right':
            switch (legendPosition) {
                case 'bottom':
                    return origin.x + ChartTheme_1.ChartCommonStyles.label.margin + dx + radius;
                case 'right':
                    return origin.x + ChartTheme_1.ChartCommonStyles.label.margin + dx;
                default:
                    return dx;
            }
        default:
            return dx;
    }
};
// Returns x coordinate for pie labels
exports.getPieLabelY = ({ dy = 0, height, labelPosition, padding, width }) => {
    const origin = chart_origin_1.getPieOrigin({ height, padding, width });
    const radius = victory_core_1.Helpers.getRadius({ height, width, padding });
    switch (labelPosition) {
        case 'center':
        case 'right':
            return origin.y + dy;
        case 'bottom':
            return origin.y + radius + ChartTheme_1.ChartCommonStyles.label.margin * 2 + dy;
        default:
            return dy;
    }
};
// Returns an approximate size for the give text
exports.getLabelTextSize = ({ text, theme }) => {
    const style = theme.legend.style.labels;
    // The approximateTextSize function returns height and width, but Victory incorrectly typed it as number
    return victory_core_1.TextSize.approximateTextSize(text, Object.assign({}, style));
};
//# sourceMappingURL=chart-label.js.map