"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalprumComponent = void 0;
var react_1 = __importStar(require("react"));
var core_1 = require("@scalprum/core");
var isEqual_1 = __importDefault(require("lodash/isEqual"));
var async_loader_1 = require("./async-loader");
var DefaultErrorComponent = function () { return react_1.default.createElement("span", null, "Error while loading component!"); };
var LoadModule = function (_a) {
    var _b = _a.fallback, fallback = _b === void 0 ? 'loading' : _b, appName = _a.appName, api = _a.api, scope = _a.scope, module = _a.module, ErrorComponent = _a.ErrorComponent, processor = _a.processor, innerRef = _a.innerRef, props = __rest(_a, ["fallback", "appName", "api", "scope", "module", "ErrorComponent", "processor", "innerRef"]);
    var _c = core_1.getAppData(appName), scriptLocation = _c.scriptLocation, manifestLocation = _c.manifestLocation;
    var _d = react_1.useState(undefined), Component = _d[0], setComponent = _d[1];
    var _e = react_1.useState(), mountedAt = _e[0], setMountedAt = _e[1];
    react_1.useEffect(function () {
        var app = core_1.getApp(appName);
        if (!app) {
            if (scriptLocation) {
                core_1.injectScript(appName, scriptLocation)
                    .then(function (_a) {
                    var scriptMountedAt = _a[1];
                    var app = core_1.getApp(appName);
                    app === null || app === void 0 ? void 0 : app.mount(api);
                    setComponent(function () { return react_1.default.lazy(async_loader_1.loadComponent(scope, module, ErrorComponent)); });
                    setMountedAt(function () { return scriptMountedAt; });
                })
                    .catch(function () {
                    setComponent(function () { return ErrorComponent; });
                });
            }
            else if (manifestLocation) {
                core_1.processManifest(manifestLocation, appName, scope, processor)
                    .then(function (items) {
                    setMountedAt(function () { return items.map(function (value) { return value[1]; }); });
                    var app = core_1.getApp(appName);
                    app === null || app === void 0 ? void 0 : app.mount(api);
                    setComponent(function () { return react_1.default.lazy(async_loader_1.loadComponent(scope, module, ErrorComponent)); });
                })
                    .catch(function () {
                    setComponent(function () { return ErrorComponent; });
                });
            }
        }
        else {
            app === null || app === void 0 ? void 0 : app.mount(api);
            setComponent(function () { return react_1.default.lazy(async_loader_1.loadComponent(scope, module, ErrorComponent)); });
        }
        return function () {
            var app = core_1.getApp(appName);
            app === null || app === void 0 ? void 0 : app.unmount();
            if (mountedAt) {
                Array.isArray(mountedAt) ? mountedAt.forEach(function (mounted) { return document.body.removeChild(mounted); }) : document.body.removeChild(mountedAt);
            }
        };
    }, []);
    return react_1.default.createElement(react_1.Suspense, { fallback: fallback }, Component ? react_1.default.createElement(Component, __assign({ ref: innerRef }, props)) : fallback);
};
var BaseScalprumComponent = (function (_super) {
    __extends(BaseScalprumComponent, _super);
    function BaseScalprumComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.state = { hasError: false };
        return _this;
    }
    BaseScalprumComponent.getDerivedStateFromError = function () {
        return { hasError: true };
    };
    BaseScalprumComponent.prototype.shouldComponentUpdate = function (nextProps, nextState) {
        if (this.state.hasError !== nextState.hasError) {
            return true;
        }
        return !isEqual_1.default(nextProps, this.props);
    };
    BaseScalprumComponent.prototype.componentDidCatch = function (error, errorInfo) {
        console.error('Scalprum encountered an error!', error);
        console.log('Error info: ', JSON.stringify(errorInfo, null, 2));
        console.log('Component stack: ', errorInfo.componentStack);
    };
    BaseScalprumComponent.prototype.render = function () {
        var _a = this.props, _b = _a.ErrorComponent, ErrorComponent = _b === void 0 ? react_1.default.createElement(DefaultErrorComponent, null) : _b, props = __rest(_a, ["ErrorComponent"]);
        if (this.state.hasError) {
            return ErrorComponent;
        }
        return react_1.default.createElement(LoadModule, __assign({}, props, { ErrorComponent: function () { return react_1.default.createElement(react_1.Fragment, null, ErrorComponent); } }));
    };
    BaseScalprumComponent.defaultProps = {
        ErrorComponent: react_1.default.createElement(DefaultErrorComponent, null),
    };
    return BaseScalprumComponent;
}(react_1.default.Component));
exports.ScalprumComponent = react_1.default.forwardRef(function (props, ref) { return (react_1.default.createElement(BaseScalprumComponent, __assign({}, props, { innerRef: ref }))); });
//# sourceMappingURL=scalprum-component.js.map