"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalprumProvider = void 0;
var react_1 = __importStar(require("react"));
var core_1 = require("@scalprum/core");
var scalprum_context_1 = require("./scalprum-context");
function ScalprumProvider(_a) {
    var config = _a.config, children = _a.children, api = _a.api;
    var _b = react_1.useState({
        initialized: false,
        config: {},
        api: api,
    }), state = _b[0], setState = _b[1];
    react_1.useEffect(function () {
        if (typeof config === 'object') {
            core_1.initialize({ scalpLets: config, api: api });
            setState(function (prev) { return (__assign(__assign({}, prev), { initialized: true, config: config })); });
        }
        if (typeof config === 'function') {
            Promise.resolve(config()).then(function (config) {
                setState(function (prev) { return (__assign(__assign({}, prev), { initialized: true, config: config })); });
                core_1.initialize({ scalpLets: config, api: api });
            });
        }
    }, [config]);
    return react_1.default.createElement(scalprum_context_1.ScalprumContext.Provider, { value: state }, children);
}
exports.ScalprumProvider = ScalprumProvider;
//# sourceMappingURL=scalprum-provider.js.map