var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
import { getApp, getAppsByRootLocation, injectScript } from '@scalprum/core';
import React, { Fragment, useEffect } from 'react';
import { unmountComponentAtNode, render } from 'react-dom';
import { Route } from 'react-router-dom';
export var ScalprumRoute = function (_a) {
    var _b;
    var _c = _a.Placeholder, Placeholder = _c === void 0 ? Fragment : _c, elementId = _a.elementId, appName = _a.appName, path = _a.path, api = _a.api, props = __rest(_a, ["Placeholder", "elementId", "appName", "path", "api"]);
    var scriptLocation = ((_b = getAppsByRootLocation(path)) === null || _b === void 0 ? void 0 : _b[0]).scriptLocation;
    useEffect(function () {
        var app = getApp(appName);
        var element = document.getElementById(elementId);
        if (!app) {
            injectScript(appName, scriptLocation).then(function () {
                var app = getApp(appName);
                var node = app.mount(api);
                render(node, element);
            });
        }
        else {
            var node = app.mount(api);
            render(node, element);
        }
        return function () {
            var app = getApp(appName);
            app.unmount();
            unmountComponentAtNode(element);
        };
    }, [path]);
    return (React.createElement(Route, __assign({}, props, { path: path }),
        React.createElement("div", { id: elementId },
            React.createElement(Placeholder, null))));
};
//# sourceMappingURL=scalprum-route.js.map