"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _exclamationCircleIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/exclamation-circle-icon"));

var _exclamationTriangleIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/exclamation-triangle-icon"));

var _Tooltip = require("@patternfly/react-core/dist/js/components/Tooltip/Tooltip.js");

var _classnames = _interopRequireDefault(require("classnames"));

require("./CullingInformation.css");

var seconds = 1000;
var minutes = seconds * 60;
var hours = minutes * 60;
var days = hours * 24;

var exact = function exact(value) {
  return "".concat(value.toUTCString().split(',')[1].slice(0, -4).trim(), " UTC");
};

var calculateTooltip = function calculateTooltip(culled, warning, currDate) {
  var culledDate = new Date(culled);
  var warningDate = new Date(warning);
  var diffTime = currDate - warningDate;
  var removeIn = Math.ceil((culledDate - currDate) / days);
  var msg = "System scheduled for inventory removal in ".concat(removeIn, " days");

  if (diffTime >= 0) {
    return {
      isError: true,
      msg: msg
    };
  }

  return {
    isWarn: true,
    msg: msg
  };
};

var CullingInformation = function CullingInformation(_ref) {
  var culled = _ref.culled,
      className = _ref.className,
      staleWarning = _ref.staleWarning,
      stale = _ref.stale,
      currDate = _ref.currDate,
      children = _ref.children,
      render = _ref.render,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["culled", "className", "staleWarning", "stale", "currDate", "children", "render"]);

  // TODO: remove comments once culling is fine
  if (new Date(currDate) - new Date(stale) < 0) {
    return render ? render({
      msg: ''
    }) : children;
  }

  var _calculateTooltip = calculateTooltip(culled, staleWarning, currDate),
      isWarn = _calculateTooltip.isWarn,
      isError = _calculateTooltip.isError,
      msg = _calculateTooltip.msg;

  if (render) {
    return /*#__PURE__*/_react["default"].createElement("span", {
      className: (0, _classnames["default"])({
        'ins-c-inventory__culling-warning': isWarn,
        'ins-c-inventory__culling-danger': isError
      })
    }, isWarn && /*#__PURE__*/_react["default"].createElement(_exclamationTriangleIcon["default"], null), isError && /*#__PURE__*/_react["default"].createElement(_exclamationCircleIcon["default"], null), render({
      msg: msg
    }));
  }

  return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, /*#__PURE__*/_react["default"].createElement(_Tooltip.Tooltip, (0, _extends2["default"])({}, props, {
    content: msg,
    position: "bottom"
  }), /*#__PURE__*/_react["default"].createElement("span", {
    className: (0, _classnames["default"])({
      'ins-c-inventory__culling-warning': isWarn,
      'ins-c-inventory__culling-danger': isError
    })
  }, isError && /*#__PURE__*/_react["default"].createElement(_exclamationCircleIcon["default"], null), isWarn && /*#__PURE__*/_react["default"].createElement(_exclamationTriangleIcon["default"], null), children)));
};

CullingInformation.propTypes = {
  culled: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number, _propTypes["default"].instanceOf(Date)]),
  staleWarning: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number, _propTypes["default"].instanceOf(Date)]),
  stale: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number, _propTypes["default"].instanceOf(Date)]),
  currDate: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].number, _propTypes["default"].instanceOf(Date)]),
  render: _propTypes["default"].func,
  className: _propTypes["default"].string,
  children: _propTypes["default"].node
};
CullingInformation.defaultProps = {
  culled: new Date(0),
  staleWarning: new Date(0),
  currDate: new Date()
};
var _default = CullingInformation;
exports["default"] = _default;