"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Badge = require("@patternfly/react-core/dist/js/components/Badge/Badge.js");

var _Chip = require("@patternfly/react-core/dist/js/components/ChipGroup/Chip.js");

var _ChipGroup = require("@patternfly/react-core/dist/js/components/ChipGroup/ChipGroup.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _classnames = _interopRequireDefault(require("classnames"));

require("./filter-chips.css");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var FilterChips = function FilterChips(_ref) {
  var className = _ref.className,
      filters = _ref.filters,
      onDelete = _ref.onDelete,
      deleteTitle = _ref.deleteTitle,
      showDeleteButton = _ref.showDeleteButton,
      onDeleteGroup = _ref.onDeleteGroup;
  var groups = filters.filter(function (group) {
    return group.category;
  });
  var groupedFilters = groups.map(function (group, groupKey) {
    return /*#__PURE__*/_react["default"].createElement(_ChipGroup.ChipGroup, (0, _extends2["default"])({
      key: "group_".concat(group.category),
      categoryName: group.category
    }, onDeleteGroup && {
      isClosable: true,
      onClick: function onClick(event) {
        event.stopPropagation();
        onDeleteGroup(event, [group], groups.filter(function (_item, key) {
          return key !== groupKey;
        }));
      }
    }), group.chips.map(function (chip) {
      return /*#__PURE__*/_react["default"].createElement(_Chip.Chip, {
        key: chip.name,
        onClick: function onClick(event) {
          event.stopPropagation();
          onDelete(event, [_objectSpread(_objectSpread({}, group), {}, {
            chips: [chip]
          })]);
        }
      }, chip.name, chip.count && /*#__PURE__*/_react["default"].createElement(_Badge.Badge, {
        key: "chip_badge_".concat(chip.id),
        isRead: chip.isRead
      }, chip.count));
    }));
  });
  var plainFilters = filters.filter(function (group) {
    return !group.category;
  });
  return /*#__PURE__*/_react["default"].createElement("span", {
    className: (0, _classnames["default"])(className, 'ins-c-chip-filters')
  }, groupedFilters, plainFilters && plainFilters.map(function (chip) {
    return /*#__PURE__*/_react["default"].createElement(_ChipGroup.ChipGroup, {
      key: "group_plain_chip_".concat(chip.name)
    }, /*#__PURE__*/_react["default"].createElement(_Chip.Chip, {
      onClick: function onClick(event) {
        event.stopPropagation();
        onDelete(event, [chip]);
      }
    }, chip.name, chip.count && /*#__PURE__*/_react["default"].createElement(_Badge.Badge, {
      key: "chip_badge_".concat(chip.id),
      isRead: chip.isRead
    }, chip.count)));
  }), (showDeleteButton === true || showDeleteButton === undefined && filters.length > 0) && /*#__PURE__*/_react["default"].createElement(_Button.Button, {
    variant: "link",
    onClick: function onClick(event) {
      return onDelete(event, filters, true);
    }
  }, deleteTitle));
};

FilterChips.propTypes = {
  className: _propTypes["default"].string,
  filters: _propTypes["default"].arrayOf(_propTypes["default"].oneOfType([_propTypes["default"].shape({
    category: _propTypes["default"].string.isRequired,
    chips: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      name: _propTypes["default"].string.isRequired,
      isRead: _propTypes["default"].bool,
      count: _propTypes["default"].number
    })).isRequired
  }), _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    isRead: _propTypes["default"].bool,
    count: _propTypes["default"].number
  })])),
  onDelete: _propTypes["default"].func,
  onDeleteGroup: _propTypes["default"].func,
  deleteTitle: _propTypes["default"].node,
  showDeleteButton: _propTypes["default"].bool
};
FilterChips.defaultProps = {
  filters: [],
  onDelete: function onDelete() {
    return undefined;
  },
  deleteTitle: 'Clear filters'
};
var _default = FilterChips;
exports["default"] = _default;