"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.Main = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _reactRedux = require("react-redux");

var _configContext = _interopRequireDefault(require("../Dark/configContext"));

require("./main.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var toKebab = function toKebab(text) {
  return text.replace(/([a-z0-9])([A-Z])/g, '$1-$2').toLowerCase();
};
/**
 * This is a component that wraps the page
 */


var Main = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(Main, _Component);

  var _super = _createSuper(Main);

  function Main() {
    (0, _classCallCheck2["default"])(this, Main);
    return _super.apply(this, arguments);
  }

  (0, _createClass2["default"])(Main, [{
    key: "calculateLocation",
    value: function calculateLocation() {
      var _this$props = this.props,
          path = _this$props.path,
          params = _this$props.params;

      if (insights && insights.chrome && insights.chrome.$internal && insights.chrome.$internal.store) {
        var chromeState = insights.chrome.$internal.store.getState();

        if (path && chromeState) {
          return path.split('/').reduce(function (acc, curr) {
            if (curr.indexOf(':') === 0) {
              acc.dynamic = _objectSpread(_objectSpread({}, acc.dynamic), {}, (0, _defineProperty2["default"])({}, "data-".concat(toKebab(curr.substr(1))), params[curr.substr(1)]));
            } else {
              acc.staticPart = [].concat((0, _toConsumableArray2["default"])(acc.staticPart), (0, _toConsumableArray2["default"])(curr !== '' ? [curr] : []));
            }

            return acc;
          }, {
            staticPart: [chromeState.chrome.appId],
            dynamic: {}
          });
        }
      }

      return {
        staticPart: []
      };
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props2 = this.props,
          className = _this$props2.className,
          children = _this$props2.children,
          params = _this$props2.params,
          path = _this$props2.path,
          props = (0, _objectWithoutProperties2["default"])(_this$props2, ["className", "children", "params", "path"]);

      var _this$calculateLocati = this.calculateLocation(),
          dynamic = _this$calculateLocati.dynamic,
          staticPart = _this$calculateLocati.staticPart;

      return /*#__PURE__*/_react["default"].createElement(_configContext["default"].Consumer, null, function () {
        var theme = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'light';
        var themeClasses = (0, _classnames["default"])((0, _defineProperty2["default"])({}, "pf-m-".concat(theme), theme === 'dark'));
        return {
          dark: /*#__PURE__*/_react["default"].createElement("section", (0, _extends2["default"])({}, props, dynamic, {
            "page-type": staticPart.join('-'),
            className: "".concat((0, _classnames["default"])(className, 'pf-l-page__main-section pf-c-page__main-section'), " ").concat(themeClasses)
          }), _react["default"].Children.map(children, function (child) {
            return /*#__PURE__*/_react["default"].cloneElement(child, {
              className: 'pf-m-dark'
            });
          })),
          light: /*#__PURE__*/_react["default"].createElement("section", (0, _extends2["default"])({}, props, dynamic, {
            "page-type": staticPart.join('-'),
            className: "".concat((0, _classnames["default"])(className, 'pf-l-page__main-section pf-c-page__main-section'))
          }), children)
        }[theme];
      });
    }
  }]);
  return Main;
}(_react.Component);

exports.Main = Main;
Main.propTypes = {
  className: _propTypes["default"].string,
  children: _propTypes["default"].any.isRequired,
  params: _propTypes["default"].any,
  path: _propTypes["default"].string
};

var _default = (0, _reactRedux.connect)(function (_ref) {
  var routerData = _ref.routerData;
  return {
    params: routerData && routerData.params,
    path: routerData && routerData.path
  };
}, function () {
  return {};
})(Main);

exports["default"] = _default;