"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _EmptyState = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyState.js");

var _EmptyStateBody = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateBody.js");

var _Title = require("@patternfly/react-core/dist/js/components/Title/Title.js");

var _Stack = require("@patternfly/react-core/dist/js/layouts/Stack/Stack.js");

var _StackItem = require("@patternfly/react-core/dist/js/layouts/Stack/StackItem.js");

var _EmptyStateIcon = require("@patternfly/react-core/dist/js/components/EmptyState/EmptyStateIcon.js");

var _hourglassHalfIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/hourglass-half-icon"));

require("./maintenance.css");

var Maintenance = function Maintenance(_ref) {
  var title = _ref.title,
      utcStartTime = _ref.utcStartTime,
      utcEndTime = _ref.utcEndTime,
      startTime = _ref.startTime,
      endTime = _ref.endTime,
      timeZone = _ref.timeZone,
      description = _ref.description,
      redirectLink = _ref.redirectLink,
      className = _ref.className,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["title", "utcStartTime", "utcEndTime", "startTime", "endTime", "timeZone", "description", "redirectLink", "className"]);
  var emptyStateClassName = (0, _classnames["default"])(className, 'ins-c-empty-state__maintenance');
  return /*#__PURE__*/_react["default"].createElement(_EmptyState.EmptyState, (0, _extends2["default"])({
    className: emptyStateClassName
  }, props), /*#__PURE__*/_react["default"].createElement(_EmptyStateIcon.EmptyStateIcon, {
    icon: _hourglassHalfIcon["default"]
  }), /*#__PURE__*/_react["default"].createElement(_Title.Title, {
    headingLevel: "h4",
    size: "lg"
  }, "Maintenance in progress"), /*#__PURE__*/_react["default"].createElement(_EmptyStateBody.EmptyStateBody, null, description ? description : /*#__PURE__*/_react["default"].createElement(_Stack.Stack, null, /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, "We are currently undergoing scheduled maintenance and will be"), /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, "unavailable from ", utcStartTime, " to ", utcEndTime, " UTC (", startTime, "-", endTime, " ", timeZone, ")."), /*#__PURE__*/_react["default"].createElement(_StackItem.StackItem, null, "For more information please visit ", /*#__PURE__*/_react["default"].createElement("a", {
    href: redirectLink
  }, "status.redhat.com"), "."))));
};

Maintenance.propTypes = {
  utcStartTime: _propTypes["default"].string,
  utcEndTime: _propTypes["default"].string,
  startTime: _propTypes["default"].string,
  endTime: _propTypes["default"].string,
  timeZone: _propTypes["default"].string,
  description: _propTypes["default"].node,
  redirectLink: _propTypes["default"].string,
  title: _propTypes["default"].node,
  className: _propTypes["default"].string
};
Maintenance.defaultProps = {
  utcStartTime: '10am',
  utcEndTime: '12am',
  startTime: '6am',
  endTime: '8am',
  timeZone: 'EST',
  redirectLink: 'https://status.redhat.com/incidents',
  title: 'Maintenance in progress'
};
var _default = Maintenance;
exports["default"] = _default;