"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _Toolbar = require("@patternfly/react-core/dist/js/components/Toolbar/Toolbar.js");

var _ToolbarContent = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarContent.js");

var _ToolbarGroup = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarGroup.js");

var _ToolbarItem = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarItem.js");

var _Pagination = require("@patternfly/react-core/dist/js/components/Pagination/Pagination.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _ToolbarExpandIconWrapper = require("@patternfly/react-core/dist/js/components/Toolbar/ToolbarExpandIconWrapper.js");

var _angleDownIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-down-icon"));

var _angleRightIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/angle-right-icon"));

var _react = _interopRequireWildcard(require("react"));

var _Actions = _interopRequireDefault(require("./Actions"));

var _BulkSelect = require("../BulkSelect");

var _ConditionalFilter = require("../ConditionalFilter");

var _DownloadButton = require("../DownloadButton");

var _FilterChips = require("../FilterChips");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _SortBy = _interopRequireDefault(require("./SortBy"));

var _reactTable = require("@patternfly/react-table");

require("./primary-toolbar.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var PrimaryToolbar = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(PrimaryToolbar, _Component);

  var _super = _createSuper(PrimaryToolbar);

  function PrimaryToolbar() {
    (0, _classCallCheck2["default"])(this, PrimaryToolbar);
    return _super.apply(this, arguments);
  }

  (0, _createClass2["default"])(PrimaryToolbar, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          id = _this$props.id,
          className = _this$props.className,
          toggleIsExpanded = _this$props.toggleIsExpanded,
          bulkSelect = _this$props.bulkSelect,
          filterConfig = _this$props.filterConfig,
          dedicatedAction = _this$props.dedicatedAction,
          actionsConfig = _this$props.actionsConfig,
          sortByConfig = _this$props.sortByConfig,
          pagination = _this$props.pagination,
          activeFiltersConfig = _this$props.activeFiltersConfig,
          children = _this$props.children,
          exportConfig = _this$props.exportConfig,
          expandAll = _this$props.expandAll,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["id", "className", "toggleIsExpanded", "bulkSelect", "filterConfig", "dedicatedAction", "actionsConfig", "sortByConfig", "pagination", "activeFiltersConfig", "children", "exportConfig", "expandAll"]);
      var overflowActions = (0, _toConsumableArray2["default"])(sortByConfig ? [{
        label: 'Sort order ASC',
        props: {
          isDisabled: sortByConfig.direction === _reactTable.SortByDirection.asc
        },
        onClick: function onClick(e) {
          return sortByConfig.onSortChange && sortByConfig.onSortChange(e, _reactTable.SortByDirection.asc);
        }
      }, {
        label: 'Sort order DESC',
        props: {
          isDisabled: sortByConfig.direction === _reactTable.SortByDirection.desc
        },
        onClick: function onClick(e) {
          return sortByConfig.onSortChange && sortByConfig.onSortChange(e, _reactTable.SortByDirection.desc);
        }
      }] : []);
      return /*#__PURE__*/_react["default"].createElement(_Toolbar.Toolbar, (0, _extends2["default"])({}, props, {
        className: "".concat(className || '', " ins-c-primary-toolbar"),
        toggleIsExpanded: toggleIsExpanded,
        id: id || 'ins-primary-data-toolbar'
      }), /*#__PURE__*/_react["default"].createElement(_ToolbarContent.ToolbarContent, null, (expandAll || bulkSelect || filterConfig || dedicatedAction) && /*#__PURE__*/_react["default"].createElement(_ToolbarGroup.ToolbarGroup, {
        className: "ins-c-primary-toolbar__group-filter pf-m-spacer-md pf-m-space-items-lg",
        variant: "filter-group"
      }, expandAll && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, null, /*#__PURE__*/_react["default"].isValidElement(expandAll) ? expandAll : /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        variant: "plain",
        "aria-label": "".concat(expandAll.isAllExpanded ? 'Collapse' : 'Expand', " all"),
        onClick: function onClick(e) {
          return expandAll.onClick(e, !expandAll.isAllExpanded);
        }
      }, /*#__PURE__*/_react["default"].createElement(_ToolbarExpandIconWrapper.ToolbarExpandIconWrapper, null, expandAll.isAllExpanded ? /*#__PURE__*/_react["default"].createElement(_angleDownIcon["default"], null) : /*#__PURE__*/_react["default"].createElement(_angleRightIcon["default"], null)))), bulkSelect && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, null, /*#__PURE__*/_react["default"].isValidElement(bulkSelect) ? bulkSelect : /*#__PURE__*/_react["default"].createElement(_BulkSelect.BulkSelect, bulkSelect)), filterConfig && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
        className: "ins-c-primary-toolbar__filter"
      }, /*#__PURE__*/_react["default"].isValidElement(filterConfig) ? filterConfig : /*#__PURE__*/_react["default"].createElement(_ConditionalFilter.ConditionalFilter, filterConfig)), dedicatedAction && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, null, dedicatedAction)), /*#__PURE__*/_react["default"].isValidElement(actionsConfig) ? actionsConfig : (actionsConfig && actionsConfig.actions && actionsConfig.actions.length > 0 || sortByConfig || exportConfig) && /*#__PURE__*/_react["default"].createElement(_Actions["default"], (0, _extends2["default"])({}, actionsConfig || {}, {
        exportConfig: exportConfig,
        overflowActions: overflowActions
      })), sortByConfig && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
        className: "ins-c-primary-toolbar__sort-by"
      }, /*#__PURE__*/_react["default"].isValidElement(sortByConfig) ? sortByConfig : /*#__PURE__*/_react["default"].createElement(_SortBy["default"], sortByConfig)), children, pagination && /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, {
        className: "ins-c-primary-toolbar__pagination"
      }, /*#__PURE__*/_react["default"].isValidElement(pagination) ? pagination : /*#__PURE__*/_react["default"].createElement(_Pagination.Pagination, (0, _extends2["default"])({
        isCompact: true
      }, pagination)))), activeFiltersConfig && /*#__PURE__*/_react["default"].isValidElement(activeFiltersConfig) ? /*#__PURE__*/_react["default"].createElement(_ToolbarContent.ToolbarContent, null, /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, null, activeFiltersConfig)) : activeFiltersConfig !== undefined && (activeFiltersConfig.filters.length > 0 || activeFiltersConfig.showDeleteButton === true) && /*#__PURE__*/_react["default"].createElement(_ToolbarContent.ToolbarContent, null, /*#__PURE__*/_react["default"].createElement(_ToolbarItem.ToolbarItem, null, /*#__PURE__*/_react["default"].createElement(_FilterChips.FilterChips, activeFiltersConfig))));
    }
  }]);
  return PrimaryToolbar;
}(_react.Component);

PrimaryToolbar.propTypes = {
  id: _propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]),
  className: _propTypes["default"].string,
  toggleIsExpanded: _propTypes["default"].func,

  /** @reference [BulkSelect props](/components/BulkSelect) */
  bulkSelect: _propTypes["default"].shape(_BulkSelect.BulkSelect.propTypes),

  /** @reference [ConditionalFilter props](/components/ConditionalFilter) */
  filterConfig: _propTypes["default"].shape(_ConditionalFilter.ConditionalFilter.propTypes),
  dedicatedAction: _propTypes["default"].node,

  /** @reference [PF pagination props](https://www.patternfly.org/v4/components/pagination#pagination) */
  pagination: _propTypes["default"].shape(_Pagination.Pagination.propTypes),

  /** @reference [SortBy props](/components/SortBy) */
  sortByConfig: _propTypes["default"].shape(_SortBy["default"].propTypes),

  /** @reference [DownloadButton props](/components/DownloadButton) */
  exportConfig: _propTypes["default"].shape(_DownloadButton.DownloadButton.propTypes),

  /** @reference [FilterChips props](/components/FilterChips) */
  activeFiltersConfig: _propTypes["default"].shape(_FilterChips.FilterChips.propTypes),
  children: _propTypes["default"].node,
  actionsConfig: _propTypes["default"].shape({
    actions: _Actions["default"].propTypes.actions,
    dropdownProps: _Actions["default"].propTypes.dropdownProps,
    onSelect: _Actions["default"].propTypes.onSelect
  }),
  expandAll: _propTypes["default"].oneOfType([_propTypes["default"].node, _propTypes["default"].shape({
    onClick: _propTypes["default"].func,
    isAllExpanded: _propTypes["default"].bool
  })])
};
PrimaryToolbar.defaultProps = {
  toggleIsExpanded: Function
};
var _default = PrimaryToolbar;
exports["default"] = _default;