"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _Dropdown = require("@patternfly/react-core/dist/js/components/Dropdown/Dropdown.js");

var _DropdownToggle = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownToggle.js");

var _DropdownItem = require("@patternfly/react-core/dist/js/components/Dropdown/DropdownItem.js");

var _Input = require("../Input");

var _searchIcon = _interopRequireDefault(require("@patternfly/react-icons/dist/js/icons/search-icon"));

require("./simple-table-filter.css");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var SimpleFilter = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(SimpleFilter, _Component);

  var _super = _createSuper(SimpleFilter);

  function SimpleFilter() {
    var _this;

    (0, _classCallCheck2["default"])(this, SimpleFilter);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      activeFilter: '',
      isOpen: false
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onToggle", function (isOpen) {
      _this.setState({
        isOpen: isOpen
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onInputChange", function (event) {
      _this.setState({
        activeFilter: event.target.value
      });

      _this.props.onFilterChange(event.target.value, _this.state.selected);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onFilterSubmit", function () {
      _this.props.onButtonClick(_this.state.activeFilter, _this.state.selected);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onFilterSelect", function (event, oneItem) {
      _this.setState({
        selected: oneItem
      });

      _this.props.onOptionSelect(event, oneItem);
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "onSelect", function () {
      _this.setState({
        isOpen: false
      });
    });
    return _this;
  }

  (0, _createClass2["default"])(SimpleFilter, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          placeholder = _this$props.placeholder,
          buttonTitle = _this$props.buttonTitle,
          className = _this$props.className,
          onButtonClick = _this$props.onButtonClick,
          onOptionSelect = _this$props.onOptionSelect,
          onFilterChange = _this$props.onFilterChange,
          options = _this$props.options,
          searchIcon = _this$props.searchIcon,
          widgetId = _this$props.widgetId,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["placeholder", "buttonTitle", "className", "onButtonClick", "onOptionSelect", "onFilterChange", "options", "searchIcon", "widgetId"]);
      var _this$state = this.state,
          isOpen = _this$state.isOpen,
          selected = _this$state.selected;
      var dropdownItems = options && options.items && options.items.map(function (oneItem) {
        return /*#__PURE__*/_react["default"].createElement(_DropdownItem.DropdownItem, {
          component: "button",
          key: oneItem.value,
          onClick: function onClick(event) {
            return _this2.onFilterSelect(event, oneItem);
          },
          "data-key": oneItem.value
        }, oneItem.title);
      });
      return /*#__PURE__*/_react["default"].createElement("div", (0, _extends2["default"])({
        className: "pf-c-input-group ins-c-filter ".concat(!buttonTitle ? 'ins-u-no-title' : '', " ").concat(className)
      }, props), options && /*#__PURE__*/_react["default"].createElement(_Dropdown.Dropdown, {
        onSelect: this.onSelect,
        isOpen: isOpen,
        toggle: /*#__PURE__*/_react["default"].createElement(_DropdownToggle.DropdownToggle, {
          onToggle: this.onToggle
        }, selected && selected.title || options.title || 'Dropdown'),
        dropdownItems: dropdownItems
      }), /*#__PURE__*/_react["default"].createElement(_Input.Input, {
        placeholder: placeholder,
        onKeyPress: function onKeyPress(event) {
          return event.key === 'Enter' && _this2.onInputChange(event);
        },
        "widget-id": widgetId,
        onChange: this.onInputChange
      }), !buttonTitle && searchIcon && /*#__PURE__*/_react["default"].createElement(_searchIcon["default"], {
        size: "sm",
        className: "ins-c-search-icon"
      }), buttonTitle && /*#__PURE__*/_react["default"].createElement(_Button.Button, {
        variant: _Button.ButtonVariant.secondary,
        action: "filter",
        onClick: this.onFilterSubmit
      }, buttonTitle));
    }
  }]);
  return SimpleFilter;
}(_react.Component);

SimpleFilter.propTypes = {
  widgetId: _propTypes["default"].string,
  buttonTitle: _propTypes["default"].string,
  placeholder: _propTypes["default"].string,
  className: _propTypes["default"].string,
  options: _propTypes["default"].shape({
    title: _propTypes["default"].string,
    items: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      value: _propTypes["default"].string,
      title: _propTypes["default"].string
    }))
  }),
  onButtonClick: _propTypes["default"].func,
  onFilterChange: _propTypes["default"].func,
  onOptionSelect: _propTypes["default"].func,
  searchIcon: _propTypes["default"].bool
};
SimpleFilter.defaultProps = {
  className: '',
  placeholder: 'Search items',
  buttonTitle: 'Filter',
  onButtonClick: function onButtonClick() {
    return undefined;
  },
  onFilterChange: function onFilterChange() {
    return undefined;
  },
  onOptionSelect: function onOptionSelect() {
    return undefined;
  },
  searchIcon: true
};
var _default = SimpleFilter;
exports["default"] = _default;