"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.SkeletonSize = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

require("./skeleton.css");

var SkeletonSize = {
  xs: 'xs',
  sm: 'sm',
  md: 'md',
  lg: 'lg'
};
exports.SkeletonSize = SkeletonSize;

var Skeleton = function Skeleton(_ref) {
  var size = _ref.size,
      isDark = _ref.isDark,
      className = _ref.className,
      props = (0, _objectWithoutProperties2["default"])(_ref, ["size", "isDark", "className"]);
  var skeletonClasses = (0, _classnames["default"])('ins-c-skeleton', "ins-c-skeleton__".concat(size), (0, _defineProperty2["default"])({}, "ins-m-dark", isDark), className);
  return /*#__PURE__*/_react["default"].createElement("div", (0, _extends2["default"])({
    className: skeletonClasses
  }, props), "\xA0");
};

var _default = Skeleton;
exports["default"] = _default;
Skeleton.propTypes = {
  className: _propTypes["default"].string,
  size: _propTypes["default"].oneOf(Object.values(SkeletonSize)),
  isDark: _propTypes["default"].bool
};
Skeleton.defaultProps = {
  size: SkeletonSize.md,
  isDark: false
};