"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

require("./tagModal.css");

var _Modal = require("@patternfly/react-core/dist/js/components/Modal/Modal.js");

var _Button = require("@patternfly/react-core/dist/js/components/Button/Button.js");

var _Tabs = require("@patternfly/react-core/dist/js/components/Tabs/Tabs.js");

var _Tab = require("@patternfly/react-core/dist/js/components/Tabs/Tab.js");

var _TabTitleText = require("@patternfly/react-core/dist/js/components/Tabs/TabTitleText.js");

var _classnames = _interopRequireDefault(require("classnames"));

var _TableWithFilter = _interopRequireDefault(require("./TableWithFilter"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2["default"])(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2["default"])(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2["default"])(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var calculateChecked = function calculateChecked() {
  var rows = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var selected = arguments.length > 1 ? arguments[1] : undefined;
  return rows.every(function (_ref) {
    var id = _ref.id;
    return selected && selected.find(function (_ref2) {
      var selectedId = _ref2.id;
      return selectedId === id;
    });
  }) ? rows.length > 0 : rows.some(function (_ref3) {
    var id = _ref3.id;
    return selected && selected.find(function (_ref4) {
      var selectedId = _ref4.id;
      return selectedId === id;
    });
  }) && null;
};

var unique = function unique(arr) {
  return arr.filter(function (_ref5, index, arr) {
    var id = _ref5.id;
    return arr.findIndex(function (_ref6) {
      var currId = _ref6.id;
      return currId === id;
    }) === index;
  });
};

var TagModal = /*#__PURE__*/function (_Component) {
  (0, _inherits2["default"])(TagModal, _Component);

  var _super = _createSuper(TagModal);

  function TagModal() {
    var _this;

    (0, _classCallCheck2["default"])(this, TagModal);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "state", {
      selectedTab: 0
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "handleTabClick", function (_event, tabIndex) {
      _this.setState({
        activeTabKey: tabIndex
      });
    });
    (0, _defineProperty2["default"])((0, _assertThisInitialized2["default"])(_this), "renderTable", function (rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData) {
      return /*#__PURE__*/_react["default"].createElement(_TableWithFilter["default"], (0, _extends2["default"])({}, _this.props, {
        rows: rows,
        pagination: pagination,
        loaded: loaded,
        calculateChecked: calculateChecked,
        unique: unique,
        filters: filters,
        title: _this.props.title,
        systemName: _this.props.systemName,
        columns: columns,
        onSelect: onSelect,
        onUpdateData: onUpdateData,
        selected: selected
      }), _this.props.children);
    });
    return _this;
  }

  (0, _createClass2["default"])(TagModal, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          title = _this$props.title,
          systemName = _this$props.systemName,
          toggleModal = _this$props.toggleModal,
          isOpen = _this$props.isOpen,
          rows = _this$props.rows,
          columns = _this$props.columns,
          children = _this$props.children,
          pagination = _this$props.pagination,
          loaded = _this$props.loaded,
          filters = _this$props.filters,
          onApply = _this$props.onApply,
          tabNames = _this$props.tabNames,
          onSelect = _this$props.onSelect,
          onUpdateData = _this$props.onUpdateData,
          selected = _this$props.selected,
          tableProps = _this$props.tableProps,
          props = (0, _objectWithoutProperties2["default"])(_this$props, ["className", "title", "systemName", "toggleModal", "isOpen", "rows", "columns", "children", "pagination", "loaded", "filters", "onApply", "tabNames", "onSelect", "onUpdateData", "selected", "tableProps"]);
      var isTabbed = Array.isArray(tabNames);
      return /*#__PURE__*/_react["default"].createElement(_Modal.Modal, (0, _extends2["default"])({}, props, {
        className: (0, _classnames["default"])('ins-c-tag-modal', className),
        isOpen: isOpen,
        title: title || "Tags for ".concat(systemName),
        onClose: function onClose(e) {
          return toggleModal(e, false);
        },
        variant: "medium"
      }, onApply && {
        actions: [/*#__PURE__*/_react["default"].createElement(_Button.Button, {
          key: "confirm",
          variant: "primary",
          isDisabled: isTabbed ? Object.values(selected || {}).every(function (values) {
            return !values || (values === null || values === void 0 ? void 0 : values.length) === 0;
          }) : !selected || (selected === null || selected === void 0 ? void 0 : selected.length) === 0,
          onClick: function onClick(e) {
            onApply();
            toggleModal(e, true);
          }
        }, "Apply ", isTabbed ? 'selected' : 'tags'), /*#__PURE__*/_react["default"].createElement(_Button.Button, {
          key: "cancel",
          variant: "link",
          onClick: function onClick(e) {
            return toggleModal(e, false);
          }
        }, "Cancel")]
      }), isTabbed ? /*#__PURE__*/_react["default"].createElement(_Tabs.Tabs, {
        activeKey: this.state.activeTabKey,
        onSelect: this.handleTabClick
      }, tabNames.map(function (item, key) {
        return /*#__PURE__*/_react["default"].createElement(_Tab.Tab, {
          key: key,
          eventKey: key,
          title: /*#__PURE__*/_react["default"].createElement(_TabTitleText.TabTitleText, null, "All ", item)
        }, _this2.renderTable(rows === null || rows === void 0 ? void 0 : rows[key], columns === null || columns === void 0 ? void 0 : columns[key], pagination === null || pagination === void 0 ? void 0 : pagination[key], loaded === null || loaded === void 0 ? void 0 : loaded[key], filters === null || filters === void 0 ? void 0 : filters[key], selected === null || selected === void 0 ? void 0 : selected[key], onSelect === null || onSelect === void 0 ? void 0 : onSelect[key], onUpdateData === null || onUpdateData === void 0 ? void 0 : onUpdateData[key]));
      })) : this.renderTable(rows, columns, pagination, loaded, filters, selected, onSelect, onUpdateData));
    }
  }]);
  return TagModal;
}(_react.Component);

TagModal.propTypes = {
  tabNames: _propTypes["default"].arrayOf(_propTypes["default"].string),
  loaded: _propTypes["default"].oneOfType([_propTypes["default"].bool, _propTypes["default"].arrayOf(_propTypes["default"].bool)]),
  title: _propTypes["default"].string,
  systemName: _propTypes["default"].string,
  isOpen: _propTypes["default"].bool,
  toggleModal: _propTypes["default"].func,
  rows: _propTypes["default"].array,
  columns: _propTypes["default"].array,
  className: _propTypes["default"].string,
  tableProps: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any)),
  onSelect: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].arrayOf(_propTypes["default"].func)]),
  onUpdateData: _propTypes["default"].oneOfType([_propTypes["default"].func, _propTypes["default"].arrayOf(_propTypes["default"].func)]),
  pagination: _propTypes["default"].oneOfType([_TableWithFilter["default"].propTypes.pagination, _propTypes["default"].arrayOf(_TableWithFilter["default"].propTypes.pagination)]),
  primaryToolbarProps: _propTypes["default"].shape((0, _defineProperty2["default"])({}, _propTypes["default"].string, _propTypes["default"].any)),
  selected: _propTypes["default"].array,
  children: _propTypes["default"].node,
  filters: _propTypes["default"].any,
  onApply: _propTypes["default"].func
};
TagModal.defaultProps = {
  loaded: false,
  isOpen: false,
  toggleModal: function toggleModal() {
    return undefined;
  },
  columns: [{
    title: 'Name'
  }, {
    title: 'Tag source'
  }],
  onUpdateData: function onUpdateData() {
    return undefined;
  },
  rows: [],
  tableProps: {},
  pagination: {
    count: 10
  }
};
var _default = TagModal;
exports["default"] = _default;