import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";

/* eslint-disable react/prop-types */
import React from 'react';
import { useEffect } from 'react';
import { useHistory, useLocation, useRouteMatch } from 'react-router-dom';
import Breadcrumbs from './Breadcrumbs';
/**
 * @deprecated
 *
 * Breadcrumbs from FE component shouldn't be used anymore.
 *
 * Use <a href="https://www.patternfly.org/v4/components/breadcrumb" target="_blank">Breadcrumbs</a> from PF repository.
 */

var ConnectedBreadcrumbs = function ConnectedBreadcrumbs(props) {
  var history = useHistory();
  var location = useLocation();
  var match = useRouteMatch();
  useEffect(function () {
    console.warn('This component will be removed in future release (next month March), do not use it anymore!');
  }, []);

  var onNavigate = function onNavigate(_event, _item, key) {
    history.go(-key);
  };

  var calculateBreadcrumbs = function calculateBreadcrumbs() {
    var current = props.current,
        mappings = props.mappings;

    if (!current && mappings) {
      var root = match.path.split('/').slice(2);
      var rest = location.pathname.substring(match.path.length).split('/').slice(1);
      return [].concat(_toConsumableArray(root), _toConsumableArray(rest.map(function (item, key) {
        return mappings[key] || item;
      })));
    } else {
      return [].concat(_toConsumableArray(location.pathname.split('/').slice(2, -1)), [current]);
    }
  };

  var mappedBreadcrumbs = calculateBreadcrumbs() || [];
  return /*#__PURE__*/React.createElement(Breadcrumbs, _extends({}, props, {
    items: mappedBreadcrumbs.slice(0, -1).map(function (item) {
      return {
        title: item,
        navigate: item
      };
    }),
    onNavigate: onNavigate,
    current: mappedBreadcrumbs.slice(-1)[0]
  }));
};

export default ConnectedBreadcrumbs;