import React from 'react';
import PropTypes from 'prop-types';
import { dateByType } from './helper';
/**
 * A component that formats date to a unified CRC format.
 * Relative date format adds a tooltip with a full date string.
 */

export default function DateFormat(_ref) {
  var date = _ref.date,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'relative' : _ref$type,
      extraTitle = _ref.extraTitle,
      _ref$tooltipProps = _ref.tooltipProps,
      tooltipProps = _ref$tooltipProps === void 0 ? {} : _ref$tooltipProps;
  var dateObj = date instanceof Date ? date : new Date(date); // Prevent treating null as valid. (new Date(null) == new Date(0) returns 1970 Jan 1)

  var invalid = date === undefined || date === null || dateObj.toString() === 'Invalid Date';
  var dateType = invalid ? 'invalid' : type;
  return /*#__PURE__*/React.createElement(React.Fragment, null, dateByType(dateType, tooltipProps, extraTitle)(dateObj));
}
DateFormat.propTypes = {
  date: PropTypes.oneOfType([PropTypes.instanceOf(Date), PropTypes.string, PropTypes.number]),

  /**
   * Output format of the date
   */
  type: PropTypes.oneOf(['exact', 'onlyDate', 'relative']),

  /**
   * Additional text in the tooltip
   */
  extraTitle: PropTypes.node,

  /**
   * <a target="_blank" href="https://www.patternfly.org/v4/components/tooltip/#props">PF Tooltip props object</a>
   */
  tooltipProps: PropTypes.object
};