import _extends from "@babel/runtime/helpers/extends";
import React from 'react';
import { Tooltip } from "@patternfly/react-core/dist/esm/components/Tooltip/Tooltip.js";
var second = 1000;
var minute = second * 60;
var hour = minute * 60;
var day = hour * 24;
var month = day * 30; // let's count that every month has 30 days

var year = day * 365;

var formatTime = function formatTime(number, unit) {
  return "".concat(number, " ").concat(number > 1 ? "".concat(unit, "s") : unit, " ago");
};

var relativeTimeTable = [{
  rightBound: Infinity,
  description: function description(date) {
    return formatTime(Math.round(date / year), 'year');
  }
}, {
  rightBound: year,
  description: function description(date) {
    return formatTime(Math.round(date / month), 'month');
  }
}, {
  rightBound: month,
  description: function description(date) {
    return formatTime(Math.round(date / day), 'day');
  }
}, {
  rightBound: day,
  description: function description(date) {
    return formatTime(Math.round(date / hour), 'hour');
  }
}, {
  rightBound: hour,
  description: function description(date) {
    return formatTime(Math.round(date / minute), 'minute');
  }
}, {
  rightBound: minute,
  description: function description() {
    return 'Just now';
  }
}];

var _exact = function exact(value) {
  return value.toUTCString().split(',')[1].slice(0, -7).trim();
};

export var addTooltip = function addTooltip(date, element, tooltipProps) {
  var extraTitle = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : '';
  return /*#__PURE__*/React.createElement(Tooltip, _extends({}, tooltipProps, {
    content: /*#__PURE__*/React.createElement("div", null, extraTitle, date)
  }), element);
};
export var dateStringByType = function dateStringByType(type) {
  return {
    exact: function exact(date) {
      return _exact(date) + ' UTC';
    },
    onlyDate: function onlyDate(date) {
      return _exact(date).slice(0, -6);
    },
    relative: function relative(date) {
      return relativeTimeTable.reduce(function (acc, i) {
        return i.rightBound > Date.now() - date ? i.description(Date.now() - date) : acc;
      }, _exact(date));
    },
    invalid: function invalid() {
      return 'Invalid date';
    }
  }[type];
};
export var dateByType = function dateByType(type, tooltipProps, extraTitle) {
  return {
    exact: function exact(date) {
      return dateStringByType(type)(date);
    },
    onlyDate: function onlyDate(date) {
      return dateStringByType(type)(date);
    },
    relative: function relative(date) {
      return addTooltip(dateStringByType('exact')(date), /*#__PURE__*/React.createElement("span", null, dateStringByType(type)(date)), tooltipProps, extraTitle);
    },
    invalid: function invalid() {
      return 'Invalid date';
    }
  }[type];
};