import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import React from 'react';
import propTypes from 'prop-types';
import classNames from 'classnames';
import "../../EmptyTable/./EmptyTable.css";

var EmptyTable = function EmptyTable(_ref) {
  var centered = _ref.centered,
      className = _ref.className,
      children = _ref.children,
      props = _objectWithoutProperties(_ref, ["centered", "className", "children"]);

  var emptyTableClasses = classNames('ins-c-table__empty', _defineProperty({}, "is-centered", centered), className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: emptyTableClasses
  }, props), " ", children);
};

export default EmptyTable;
EmptyTable.propTypes = {
  centered: propTypes.bool,
  children: propTypes.any,
  className: propTypes.string
};