import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

import React from 'react';
import PropTypes from 'prop-types';
import { Badge } from "@patternfly/react-core/dist/esm/components/Badge/Badge.js";
import { Chip } from "@patternfly/react-core/dist/esm/components/ChipGroup/Chip.js";
import { ChipGroup } from "@patternfly/react-core/dist/esm/components/ChipGroup/ChipGroup.js";
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import classNames from 'classnames';
import "../../FilterChips/./filter-chips.css";

var FilterChips = function FilterChips(_ref) {
  var className = _ref.className,
      filters = _ref.filters,
      onDelete = _ref.onDelete,
      deleteTitle = _ref.deleteTitle,
      showDeleteButton = _ref.showDeleteButton,
      onDeleteGroup = _ref.onDeleteGroup;
  var groups = filters.filter(function (group) {
    return group.category;
  });
  var groupedFilters = groups.map(function (group, groupKey) {
    return /*#__PURE__*/React.createElement(ChipGroup, _extends({
      key: "group_".concat(group.category),
      categoryName: group.category
    }, onDeleteGroup && {
      isClosable: true,
      onClick: function onClick(event) {
        event.stopPropagation();
        onDeleteGroup(event, [group], groups.filter(function (_item, key) {
          return key !== groupKey;
        }));
      }
    }), group.chips.map(function (chip) {
      return /*#__PURE__*/React.createElement(Chip, {
        key: chip.name,
        onClick: function onClick(event) {
          event.stopPropagation();
          onDelete(event, [_objectSpread(_objectSpread({}, group), {}, {
            chips: [chip]
          })]);
        }
      }, chip.name, chip.count && /*#__PURE__*/React.createElement(Badge, {
        key: "chip_badge_".concat(chip.id),
        isRead: chip.isRead
      }, chip.count));
    }));
  });
  var plainFilters = filters.filter(function (group) {
    return !group.category;
  });
  return /*#__PURE__*/React.createElement("span", {
    className: classNames(className, 'ins-c-chip-filters')
  }, groupedFilters, plainFilters && plainFilters.map(function (chip) {
    return /*#__PURE__*/React.createElement(ChipGroup, {
      key: "group_plain_chip_".concat(chip.name)
    }, /*#__PURE__*/React.createElement(Chip, {
      onClick: function onClick(event) {
        event.stopPropagation();
        onDelete(event, [chip]);
      }
    }, chip.name, chip.count && /*#__PURE__*/React.createElement(Badge, {
      key: "chip_badge_".concat(chip.id),
      isRead: chip.isRead
    }, chip.count)));
  }), (showDeleteButton === true || showDeleteButton === undefined && filters.length > 0) && /*#__PURE__*/React.createElement(Button, {
    variant: "link",
    onClick: function onClick(event) {
      return onDelete(event, filters, true);
    }
  }, deleteTitle));
};

FilterChips.propTypes = {
  className: PropTypes.string,
  filters: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.shape({
    category: PropTypes.string.isRequired,
    chips: PropTypes.arrayOf(PropTypes.shape({
      name: PropTypes.string.isRequired,
      isRead: PropTypes.bool,
      count: PropTypes.number
    })).isRequired
  }), PropTypes.shape({
    name: PropTypes.string.isRequired,
    isRead: PropTypes.bool,
    count: PropTypes.number
  })])),
  onDelete: PropTypes.func,
  onDeleteGroup: PropTypes.func,
  deleteTitle: PropTypes.node,
  showDeleteButton: PropTypes.bool
};
FilterChips.defaultProps = {
  filters: [],
  onDelete: function onDelete() {
    return undefined;
  },
  deleteTitle: 'Clear filters'
};
export default FilterChips;