import _extends from "@babel/runtime/helpers/extends";
import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
var AsyncInventory = /*#__PURE__*/React.lazy(function () {
  return import('./AsyncInventory');
});
import { ScalprumComponent } from '@scalprum/react-core';
import { useHistory } from 'react-router-dom';
import { useStore } from 'react-redux';
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner/Spinner.js";

var BaseInventoryDetail = function BaseInventoryDetail(props) {
  var history = useHistory();
  var store = useStore();
  return /*#__PURE__*/React.createElement(Suspense, {
    fallback: props.fallback
  }, /*#__PURE__*/React.createElement(ScalprumComponent, _extends({
    history: history,
    store: store,
    appName: "chrome",
    module: "./InventoryDetail",
    scope: "chrome",
    ErrorComponent: /*#__PURE__*/React.createElement(AsyncInventory, _extends({
      component: "InventoryDetail"
    }, props)),
    ref: props.innerRef
  }, props)));
};

BaseInventoryDetail.propTypes = {
  fallback: PropTypes.node,
  innerRef: PropTypes.object
};
/**
 * Inventory sub component.
 *
 * This component shows complete inventory detail with system info and app's detail in tab(s).
 */

var InventoryDetail = /*#__PURE__*/React.forwardRef(function (props, ref) {
  return /*#__PURE__*/React.createElement(BaseInventoryDetail, _extends({
    innerRef: ref
  }, props));
});
InventoryDetail.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: PropTypes.node
};
InventoryDetail.defaultProps = {
  fallback: /*#__PURE__*/React.createElement(Bullseye, {
    className: "pf-u-p-lg"
  }, /*#__PURE__*/React.createElement(Spinner, {
    size: "xl"
  }))
};
export default InventoryDetail;