import _extends from "@babel/runtime/helpers/extends";
import React, { Suspense } from 'react';
import PropTypes from 'prop-types';
var AsyncInventory = /*#__PURE__*/React.lazy(function () {
  return import('./AsyncInventory');
});
import { ScalprumComponent } from '@scalprum/react-core';
import { useHistory } from 'react-router-dom';
import { useStore } from 'react-redux';
import { Bullseye } from "@patternfly/react-core/dist/esm/layouts/Bullseye/Bullseye.js";
import { Spinner } from "@patternfly/react-core/dist/esm/components/Spinner/Spinner.js";
/**
 * Inventory sub component.
 *
 * This component is used to manipulate with inventory tags.
 */

var BaseTagWithDialog = function BaseTagWithDialog(props) {
  var history = useHistory();
  var store = useStore();
  return /*#__PURE__*/React.createElement(Suspense, {
    fallback: props.fallback
  }, /*#__PURE__*/React.createElement(ScalprumComponent, _extends({
    history: history,
    store: store,
    appName: "chrome",
    module: "./TagWithDialog",
    scope: "chrome",
    ErrorComponent: /*#__PURE__*/React.createElement(AsyncInventory, _extends({
      component: "TagWithDialog"
    }, props)),
    ref: props.innerRef
  }, props)));
};

BaseTagWithDialog.propTypes = {
  fallback: PropTypes.node,
  innerRef: PropTypes.object
};
/**
 * Inventory sub component.
 *
 * This component shows systems table connected to redux.
 */

var TagWithDialog = /*#__PURE__*/React.forwardRef(function (props, ref) {
  return /*#__PURE__*/React.createElement(BaseTagWithDialog, _extends({
    innerRef: ref
  }, props));
});
TagWithDialog.propTypes = {
  /** React Suspense fallback component. <a href="https://reactjs.org/docs/code-splitting.html#reactlazy" target="_blank">Learn more</a>. */
  fallback: PropTypes.node
};
TagWithDialog.defaultProps = {
  fallback: /*#__PURE__*/React.createElement(Bullseye, {
    className: "pf-u-p-lg"
  }, /*#__PURE__*/React.createElement(Spinner, {
    size: "xl"
  }))
};
export default TagWithDialog;