import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

import React, { Component } from 'react';
import PaginationNext from './PaginationNext';
import PropTypes from 'prop-types';
export var dropDirection = {
  up: 'up',
  down: 'down'
};
var pager = [10, 15, 20, 25, 50];

var Pagination = /*#__PURE__*/function (_Component) {
  _inherits(Pagination, _Component);

  var _super = _createSuper(Pagination);

  function Pagination() {
    var _this;

    _classCallCheck(this, Pagination);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "setPage", function (page, debounce) {
      var currPage = _this.props.page;
      var perPage = _this.props.itemsPerPage || pager[0];
      var maxPage = Math.ceil(_this.props.numberOfItems / perPage);
      page = isNaN(page) ? currPage : page;
      page = page > maxPage ? maxPage : page < 0 ? 0 : page;
      _this.props.hasOwnProperty('onSetPage') && _this.props.onSetPage(page, debounce);
    });

    return _this;
  }

  _createClass(Pagination, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          page = _this$props.page,
          onSetPage = _this$props.onSetPage,
          numberOfItems = _this$props.numberOfItems,
          itemsPerPage = _this$props.itemsPerPage,
          perPageOptions = _this$props.perPageOptions,
          onPerPageSelect = _this$props.onPerPageSelect,
          onFirstPage = _this$props.onFirstPage,
          onLastPage = _this$props.onLastPage,
          onPreviousPage = _this$props.onPreviousPage,
          onNextPage = _this$props.onNextPage,
          props = _objectWithoutProperties(_this$props, ["page", "onSetPage", "numberOfItems", "itemsPerPage", "perPageOptions", "onPerPageSelect", "onFirstPage", "onLastPage", "onPreviousPage", "onNextPage"]);

      var pagerOptions = perPageOptions || pager;
      var perPage = itemsPerPage || pagerOptions[0];
      var lastPage = Math.ceil(numberOfItems / perPage);
      var lastIndex = numberOfItems === 0 ? 0 : page === lastPage ? numberOfItems : page * perPage;
      var firstIndex = numberOfItems === 0 ? 0 : (page - 1) * perPage + 1;
      return /*#__PURE__*/React.createElement(PaginationNext, _extends({}, props, {
        itemCount: this.props.numberOfItems,
        className: "ins-c-pagination-next",
        itemsStart: firstIndex,
        itemsEnd: lastIndex,
        lastPage: lastPage || 1,
        dropDirection: this.props.direction,
        onFirstPage: onFirstPage,
        onLastPage: onLastPage,
        onPreviousPage: onPreviousPage,
        onNextPage: onNextPage,
        perPage: perPage,
        onSetPerPage: function onSetPerPage(_event, value) {
          return _this2.props.onPerPageSelect(value);
        },
        page: this.props.page,
        setPage: function setPage(event, page) {
          return _this2.setPage(page, event.currentTarget.tagName === 'INPUT');
        },
        perPageOptions: pagerOptions.map(function (value) {
          return {
            title: value,
            value: value
          };
        })
      }));
    }
  }]);

  return Pagination;
}(Component);

Pagination.propTypes = {
  direction: PropTypes.oneOf(Object.keys(dropDirection)),
  viewType: PropTypes.string,
  itemsPerPage: PropTypes.number,
  perPageOptions: PropTypes.arrayOf(PropTypes.number),
  numberOfItems: PropTypes.number.isRequired,
  onSetPage: PropTypes.func,
  onPerPageSelect: PropTypes.func,
  onFirstPage: PropTypes.func,
  onLastPage: PropTypes.func,
  onPreviousPage: PropTypes.func,
  onNextPage: PropTypes.func,
  page: PropTypes.number
};
Pagination.defaultProps = {
  page: 1
};
export default Pagination;