import React from 'react';
import PropTypes from 'prop-types';
import { SortByDirection } from '@patternfly/react-table';
import { Button } from "@patternfly/react-core/dist/esm/components/Button/Button.js";
import SortAmountDownIcon from "@patternfly/react-icons/dist/esm/icons/sort-amount-down-icon";
import SortAmountUpIcon from "@patternfly/react-icons/dist/esm/icons/sort-amount-up-icon";
export function flipDirection(direction) {
  return direction === SortByDirection.asc ? SortByDirection.desc : SortByDirection.asc;
}

var SortBy = function SortBy(_ref) {
  var direction = _ref.direction,
      onSortChange = _ref.onSortChange;
  return /*#__PURE__*/React.createElement(Button, {
    variant: "plain",
    onClick: function onClick(e) {
      return onSortChange(e, flipDirection(direction));
    }
  }, direction === SortByDirection.asc ? /*#__PURE__*/React.createElement(SortAmountUpIcon, {
    size: "sm"
  }) : /*#__PURE__*/React.createElement(SortAmountDownIcon, {
    size: "sm"
  }));
};

SortBy.propTypes = {
  direction: PropTypes.oneOf(Object.values(SortByDirection)),
  onSortChange: PropTypes.func
};
SortBy.defaultProps = {
  direction: SortByDirection.asc,
  onSortChange: function onSortChange() {
    return undefined;
  }
};
export default SortBy;